package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.IntegerOptional
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class MongoDbDataProviderSettings(
    serverName: Optional[String] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent,
    databaseName: Optional[String] = Optional.Absent,
    sslMode: Optional[zio.aws.databasemigration.model.DmsSslModeValue] =
      Optional.Absent,
    certificateArn: Optional[String] = Optional.Absent,
    authType: Optional[zio.aws.databasemigration.model.AuthTypeValue] =
      Optional.Absent,
    authSource: Optional[String] = Optional.Absent,
    authMechanism: Optional[
      zio.aws.databasemigration.model.AuthMechanismValue
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.MongoDbDataProviderSettings = {
    import MongoDbDataProviderSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.MongoDbDataProviderSettings
      .builder()
      .optionallyWith(serverName.map(value => value: java.lang.String))(
        _.serverName
      )
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .optionallyWith(sslMode.map(value => value.unwrap))(_.sslMode)
      .optionallyWith(certificateArn.map(value => value: java.lang.String))(
        _.certificateArn
      )
      .optionallyWith(authType.map(value => value.unwrap))(_.authType)
      .optionallyWith(authSource.map(value => value: java.lang.String))(
        _.authSource
      )
      .optionallyWith(authMechanism.map(value => value.unwrap))(_.authMechanism)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.MongoDbDataProviderSettings.ReadOnly =
    zio.aws.databasemigration.model.MongoDbDataProviderSettings
      .wrap(buildAwsValue())
}
object MongoDbDataProviderSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.MongoDbDataProviderSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.MongoDbDataProviderSettings =
      zio.aws.databasemigration.model.MongoDbDataProviderSettings(
        serverName.map(value => value),
        port.map(value => value),
        databaseName.map(value => value),
        sslMode.map(value => value),
        certificateArn.map(value => value),
        authType.map(value => value),
        authSource.map(value => value),
        authMechanism.map(value => value)
      )
    def serverName: Optional[String]
    def port: Optional[IntegerOptional]
    def databaseName: Optional[String]
    def sslMode: Optional[zio.aws.databasemigration.model.DmsSslModeValue]
    def certificateArn: Optional[String]
    def authType: Optional[zio.aws.databasemigration.model.AuthTypeValue]
    def authSource: Optional[String]
    def authMechanism
        : Optional[zio.aws.databasemigration.model.AuthMechanismValue]
    def getServerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverName", serverName)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getSslMode
        : ZIO[Any, AwsError, zio.aws.databasemigration.model.DmsSslModeValue] =
      AwsError.unwrapOptionField("sslMode", sslMode)
    def getCertificateArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getAuthType
        : ZIO[Any, AwsError, zio.aws.databasemigration.model.AuthTypeValue] =
      AwsError.unwrapOptionField("authType", authType)
    def getAuthSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("authSource", authSource)
    def getAuthMechanism: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.AuthMechanismValue
    ] = AwsError.unwrapOptionField("authMechanism", authMechanism)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.MongoDbDataProviderSettings
  ) extends zio.aws.databasemigration.model.MongoDbDataProviderSettings.ReadOnly {
    override val serverName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serverName())
      .map(value => value: String)
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val databaseName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value => value: String)
    override val sslMode
        : Optional[zio.aws.databasemigration.model.DmsSslModeValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sslMode())
        .map(value =>
          zio.aws.databasemigration.model.DmsSslModeValue.wrap(value)
        )
    override val certificateArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateArn())
      .map(value => value: String)
    override val authType
        : Optional[zio.aws.databasemigration.model.AuthTypeValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authType())
        .map(value => zio.aws.databasemigration.model.AuthTypeValue.wrap(value))
    override val authSource: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.authSource())
      .map(value => value: String)
    override val authMechanism
        : Optional[zio.aws.databasemigration.model.AuthMechanismValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authMechanism())
        .map(value =>
          zio.aws.databasemigration.model.AuthMechanismValue.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.MongoDbDataProviderSettings
  ): zio.aws.databasemigration.model.MongoDbDataProviderSettings.ReadOnly =
    new Wrapper(impl)
}
