package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ModifyReplicationConfigResponse(
    replicationConfig: Optional[
      zio.aws.databasemigration.model.ReplicationConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ModifyReplicationConfigResponse = {
    import ModifyReplicationConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ModifyReplicationConfigResponse
      .builder()
      .optionallyWith(replicationConfig.map(value => value.buildAwsValue()))(
        _.replicationConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ModifyReplicationConfigResponse.ReadOnly =
    zio.aws.databasemigration.model.ModifyReplicationConfigResponse
      .wrap(buildAwsValue())
}
object ModifyReplicationConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ModifyReplicationConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.ModifyReplicationConfigResponse =
      zio.aws.databasemigration.model.ModifyReplicationConfigResponse(
        replicationConfig.map(value => value.asEditable)
      )
    def replicationConfig
        : Optional[zio.aws.databasemigration.model.ReplicationConfig.ReadOnly]
    def getReplicationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ReplicationConfig.ReadOnly
    ] = AwsError.unwrapOptionField("replicationConfig", replicationConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyReplicationConfigResponse
  ) extends zio.aws.databasemigration.model.ModifyReplicationConfigResponse.ReadOnly {
    override val replicationConfig
        : Optional[zio.aws.databasemigration.model.ReplicationConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationConfig())
        .map(value =>
          zio.aws.databasemigration.model.ReplicationConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyReplicationConfigResponse
  ): zio.aws.databasemigration.model.ModifyReplicationConfigResponse.ReadOnly =
    new Wrapper(impl)
}
