package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.databasemigration.model.primitives.BooleanOptional
import scala.jdk.CollectionConverters.*
final case class ModifyEventSubscriptionRequest(
    subscriptionName: String,
    snsTopicArn: Optional[String] = Optional.Absent,
    sourceType: Optional[String] = Optional.Absent,
    eventCategories: Optional[Iterable[String]] = Optional.Absent,
    enabled: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ModifyEventSubscriptionRequest = {
    import ModifyEventSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ModifyEventSubscriptionRequest
      .builder()
      .subscriptionName(subscriptionName: java.lang.String)
      .optionallyWith(snsTopicArn.map(value => value: java.lang.String))(
        _.snsTopicArn
      )
      .optionallyWith(sourceType.map(value => value: java.lang.String))(
        _.sourceType
      )
      .optionallyWith(
        eventCategories.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.eventCategories)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ModifyEventSubscriptionRequest.ReadOnly =
    zio.aws.databasemigration.model.ModifyEventSubscriptionRequest
      .wrap(buildAwsValue())
}
object ModifyEventSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ModifyEventSubscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.ModifyEventSubscriptionRequest =
      zio.aws.databasemigration.model.ModifyEventSubscriptionRequest(
        subscriptionName,
        snsTopicArn.map(value => value),
        sourceType.map(value => value),
        eventCategories.map(value => value),
        enabled.map(value => value)
      )
    def subscriptionName: String
    def snsTopicArn: Optional[String]
    def sourceType: Optional[String]
    def eventCategories: Optional[List[String]]
    def enabled: Optional[BooleanOptional]
    def getSubscriptionName: ZIO[Any, Nothing, String] =
      ZIO.succeed(subscriptionName)
    def getSnsTopicArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArn)
    def getSourceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getEventCategories: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("eventCategories", eventCategories)
    def getEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyEventSubscriptionRequest
  ) extends zio.aws.databasemigration.model.ModifyEventSubscriptionRequest.ReadOnly {
    override val subscriptionName: String = impl.subscriptionName(): String
    override val snsTopicArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snsTopicArn())
      .map(value => value: String)
    override val sourceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceType())
      .map(value => value: String)
    override val eventCategories: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.eventCategories())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val enabled: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyEventSubscriptionRequest
  ): zio.aws.databasemigration.model.ModifyEventSubscriptionRequest.ReadOnly =
    new Wrapper(impl)
}
