package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.databasemigration.model.primitives.BooleanOptional
import scala.jdk.CollectionConverters.*
final case class ModifyDataProviderRequest(
    dataProviderIdentifier: String,
    dataProviderName: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    engine: Optional[String] = Optional.Absent,
    exactSettings: Optional[BooleanOptional] = Optional.Absent,
    settings: Optional[zio.aws.databasemigration.model.DataProviderSettings] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ModifyDataProviderRequest = {
    import ModifyDataProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ModifyDataProviderRequest
      .builder()
      .dataProviderIdentifier(dataProviderIdentifier: java.lang.String)
      .optionallyWith(dataProviderName.map(value => value: java.lang.String))(
        _.dataProviderName
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(exactSettings.map(value => value: java.lang.Boolean))(
        _.exactSettings
      )
      .optionallyWith(settings.map(value => value.buildAwsValue()))(_.settings)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ModifyDataProviderRequest.ReadOnly =
    zio.aws.databasemigration.model.ModifyDataProviderRequest
      .wrap(buildAwsValue())
}
object ModifyDataProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ModifyDataProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.ModifyDataProviderRequest =
      zio.aws.databasemigration.model.ModifyDataProviderRequest(
        dataProviderIdentifier,
        dataProviderName.map(value => value),
        description.map(value => value),
        engine.map(value => value),
        exactSettings.map(value => value),
        settings.map(value => value.asEditable)
      )
    def dataProviderIdentifier: String
    def dataProviderName: Optional[String]
    def description: Optional[String]
    def engine: Optional[String]
    def exactSettings: Optional[BooleanOptional]
    def settings: Optional[
      zio.aws.databasemigration.model.DataProviderSettings.ReadOnly
    ]
    def getDataProviderIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dataProviderIdentifier)
    def getDataProviderName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataProviderName", dataProviderName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getExactSettings: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("exactSettings", exactSettings)
    def getSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.DataProviderSettings.ReadOnly
    ] = AwsError.unwrapOptionField("settings", settings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyDataProviderRequest
  ) extends zio.aws.databasemigration.model.ModifyDataProviderRequest.ReadOnly {
    override val dataProviderIdentifier: String =
      impl.dataProviderIdentifier(): String
    override val dataProviderName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dataProviderName())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val engine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => value: String)
    override val exactSettings: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exactSettings())
        .map(value => value: BooleanOptional)
    override val settings: Optional[
      zio.aws.databasemigration.model.DataProviderSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.settings())
      .map(value =>
        zio.aws.databasemigration.model.DataProviderSettings.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyDataProviderRequest
  ): zio.aws.databasemigration.model.ModifyDataProviderRequest.ReadOnly =
    new Wrapper(impl)
}
