package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ModifyDataMigrationResponse(
    dataMigration: Optional[zio.aws.databasemigration.model.DataMigration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ModifyDataMigrationResponse = {
    import ModifyDataMigrationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ModifyDataMigrationResponse
      .builder()
      .optionallyWith(dataMigration.map(value => value.buildAwsValue()))(
        _.dataMigration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ModifyDataMigrationResponse.ReadOnly =
    zio.aws.databasemigration.model.ModifyDataMigrationResponse
      .wrap(buildAwsValue())
}
object ModifyDataMigrationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ModifyDataMigrationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.ModifyDataMigrationResponse =
      zio.aws.databasemigration.model.ModifyDataMigrationResponse(
        dataMigration.map(value => value.asEditable)
      )
    def dataMigration
        : Optional[zio.aws.databasemigration.model.DataMigration.ReadOnly]
    def getDataMigration: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.DataMigration.ReadOnly
    ] = AwsError.unwrapOptionField("dataMigration", dataMigration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyDataMigrationResponse
  ) extends zio.aws.databasemigration.model.ModifyDataMigrationResponse.ReadOnly {
    override val dataMigration
        : Optional[zio.aws.databasemigration.model.DataMigration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataMigration())
        .map(value => zio.aws.databasemigration.model.DataMigration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyDataMigrationResponse
  ): zio.aws.databasemigration.model.ModifyDataMigrationResponse.ReadOnly =
    new Wrapper(impl)
}
