package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.{
  SecretString,
  IntegerOptional,
  BooleanOptional
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ModifyDataMigrationRequest(
    dataMigrationIdentifier: String,
    dataMigrationName: Optional[String] = Optional.Absent,
    enableCloudwatchLogs: Optional[BooleanOptional] = Optional.Absent,
    serviceAccessRoleArn: Optional[String] = Optional.Absent,
    dataMigrationType: Optional[
      zio.aws.databasemigration.model.MigrationTypeValue
    ] = Optional.Absent,
    sourceDataSettings: Optional[
      Iterable[zio.aws.databasemigration.model.SourceDataSetting]
    ] = Optional.Absent,
    numberOfJobs: Optional[IntegerOptional] = Optional.Absent,
    selectionRules: Optional[SecretString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ModifyDataMigrationRequest = {
    import ModifyDataMigrationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ModifyDataMigrationRequest
      .builder()
      .dataMigrationIdentifier(dataMigrationIdentifier: java.lang.String)
      .optionallyWith(dataMigrationName.map(value => value: java.lang.String))(
        _.dataMigrationName
      )
      .optionallyWith(
        enableCloudwatchLogs.map(value => value: java.lang.Boolean)
      )(_.enableCloudwatchLogs)
      .optionallyWith(
        serviceAccessRoleArn.map(value => value: java.lang.String)
      )(_.serviceAccessRoleArn)
      .optionallyWith(dataMigrationType.map(value => value.unwrap))(
        _.dataMigrationType
      )
      .optionallyWith(
        sourceDataSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sourceDataSettings)
      .optionallyWith(numberOfJobs.map(value => value: Integer))(_.numberOfJobs)
      .optionallyWith(
        selectionRules.map(value =>
          SecretString.unwrap(value): java.lang.String
        )
      )(_.selectionRules)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ModifyDataMigrationRequest.ReadOnly =
    zio.aws.databasemigration.model.ModifyDataMigrationRequest
      .wrap(buildAwsValue())
}
object ModifyDataMigrationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ModifyDataMigrationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.ModifyDataMigrationRequest =
      zio.aws.databasemigration.model.ModifyDataMigrationRequest(
        dataMigrationIdentifier,
        dataMigrationName.map(value => value),
        enableCloudwatchLogs.map(value => value),
        serviceAccessRoleArn.map(value => value),
        dataMigrationType.map(value => value),
        sourceDataSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        numberOfJobs.map(value => value),
        selectionRules.map(value => value)
      )
    def dataMigrationIdentifier: String
    def dataMigrationName: Optional[String]
    def enableCloudwatchLogs: Optional[BooleanOptional]
    def serviceAccessRoleArn: Optional[String]
    def dataMigrationType
        : Optional[zio.aws.databasemigration.model.MigrationTypeValue]
    def sourceDataSettings: Optional[
      List[zio.aws.databasemigration.model.SourceDataSetting.ReadOnly]
    ]
    def numberOfJobs: Optional[IntegerOptional]
    def selectionRules: Optional[SecretString]
    def getDataMigrationIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dataMigrationIdentifier)
    def getDataMigrationName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataMigrationName", dataMigrationName)
    def getEnableCloudwatchLogs: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("enableCloudwatchLogs", enableCloudwatchLogs)
    def getServiceAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceAccessRoleArn", serviceAccessRoleArn)
    def getDataMigrationType: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.MigrationTypeValue
    ] = AwsError.unwrapOptionField("dataMigrationType", dataMigrationType)
    def getSourceDataSettings: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.SourceDataSetting.ReadOnly
    ]] = AwsError.unwrapOptionField("sourceDataSettings", sourceDataSettings)
    def getNumberOfJobs: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numberOfJobs", numberOfJobs)
    def getSelectionRules: ZIO[Any, AwsError, SecretString] =
      AwsError.unwrapOptionField("selectionRules", selectionRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyDataMigrationRequest
  ) extends zio.aws.databasemigration.model.ModifyDataMigrationRequest.ReadOnly {
    override val dataMigrationIdentifier: String =
      impl.dataMigrationIdentifier(): String
    override val dataMigrationName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dataMigrationName())
      .map(value => value: String)
    override val enableCloudwatchLogs: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableCloudwatchLogs())
        .map(value => value: BooleanOptional)
    override val serviceAccessRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceAccessRoleArn())
      .map(value => value: String)
    override val dataMigrationType
        : Optional[zio.aws.databasemigration.model.MigrationTypeValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataMigrationType())
        .map(value =>
          zio.aws.databasemigration.model.MigrationTypeValue.wrap(value)
        )
    override val sourceDataSettings: Optional[
      List[zio.aws.databasemigration.model.SourceDataSetting.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceDataSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.SourceDataSetting.wrap(item)
        }.toList
      )
    override val numberOfJobs: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.numberOfJobs())
      .map(value => value: IntegerOptional)
    override val selectionRules: Optional[SecretString] = zio.aws.core.internal
      .optionalFromNullable(impl.selectionRules())
      .map(value =>
        zio.aws.databasemigration.model.primitives.SecretString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyDataMigrationRequest
  ): zio.aws.databasemigration.model.ModifyDataMigrationRequest.ReadOnly =
    new Wrapper(impl)
}
