package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ModifyConversionConfigurationResponse(
    migrationProjectIdentifier: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ModifyConversionConfigurationResponse = {
    import ModifyConversionConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ModifyConversionConfigurationResponse
      .builder()
      .optionallyWith(
        migrationProjectIdentifier.map(value => value: java.lang.String)
      )(_.migrationProjectIdentifier)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ModifyConversionConfigurationResponse.ReadOnly =
    zio.aws.databasemigration.model.ModifyConversionConfigurationResponse
      .wrap(buildAwsValue())
}
object ModifyConversionConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ModifyConversionConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.ModifyConversionConfigurationResponse =
      zio.aws.databasemigration.model.ModifyConversionConfigurationResponse(
        migrationProjectIdentifier.map(value => value)
      )
    def migrationProjectIdentifier: Optional[String]
    def getMigrationProjectIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "migrationProjectIdentifier",
        migrationProjectIdentifier
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyConversionConfigurationResponse
  ) extends zio.aws.databasemigration.model.ModifyConversionConfigurationResponse.ReadOnly {
    override val migrationProjectIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.migrationProjectIdentifier())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyConversionConfigurationResponse
  ): zio.aws.databasemigration.model.ModifyConversionConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
