package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Limitation(
    databaseId: Optional[String] = Optional.Absent,
    engineName: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    impact: Optional[String] = Optional.Absent,
    `type`: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.Limitation = {
    import Limitation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.Limitation
      .builder()
      .optionallyWith(databaseId.map(value => value: java.lang.String))(
        _.databaseId
      )
      .optionallyWith(engineName.map(value => value: java.lang.String))(
        _.engineName
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(impact.map(value => value: java.lang.String))(_.impact)
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.Limitation.ReadOnly =
    zio.aws.databasemigration.model.Limitation.wrap(buildAwsValue())
}
object Limitation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.Limitation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.Limitation =
      zio.aws.databasemigration.model.Limitation(
        databaseId.map(value => value),
        engineName.map(value => value),
        name.map(value => value),
        description.map(value => value),
        impact.map(value => value),
        `type`.map(value => value)
      )
    def databaseId: Optional[String]
    def engineName: Optional[String]
    def name: Optional[String]
    def description: Optional[String]
    def impact: Optional[String]
    def `type`: Optional[String]
    def getDatabaseId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseId", databaseId)
    def getEngineName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineName", engineName)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getImpact: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("impact", impact)
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.Limitation
  ) extends zio.aws.databasemigration.model.Limitation.ReadOnly {
    override val databaseId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseId())
      .map(value => value: String)
    override val engineName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineName())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val impact: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.impact())
      .map(value => value: String)
    override val `type`: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.Limitation
  ): zio.aws.databasemigration.model.Limitation.ReadOnly = new Wrapper(impl)
}
