package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.IntegerOptional
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class InventoryData(
    numberOfDatabases: Optional[IntegerOptional] = Optional.Absent,
    numberOfSchemas: Optional[IntegerOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.InventoryData = {
    import InventoryData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.InventoryData
      .builder()
      .optionallyWith(numberOfDatabases.map(value => value: Integer))(
        _.numberOfDatabases
      )
      .optionallyWith(numberOfSchemas.map(value => value: Integer))(
        _.numberOfSchemas
      )
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.InventoryData.ReadOnly =
    zio.aws.databasemigration.model.InventoryData.wrap(buildAwsValue())
}
object InventoryData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.InventoryData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.InventoryData =
      zio.aws.databasemigration.model.InventoryData(
        numberOfDatabases.map(value => value),
        numberOfSchemas.map(value => value)
      )
    def numberOfDatabases: Optional[IntegerOptional]
    def numberOfSchemas: Optional[IntegerOptional]
    def getNumberOfDatabases: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numberOfDatabases", numberOfDatabases)
    def getNumberOfSchemas: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numberOfSchemas", numberOfSchemas)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.InventoryData
  ) extends zio.aws.databasemigration.model.InventoryData.ReadOnly {
    override val numberOfDatabases: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfDatabases())
        .map(value => value: IntegerOptional)
    override val numberOfSchemas: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfSchemas())
        .map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.InventoryData
  ): zio.aws.databasemigration.model.InventoryData.ReadOnly = new Wrapper(impl)
}
