package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.{
  BooleanOptional,
  IntegerOptional,
  SecretString
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class IBMDb2Settings(
    databaseName: Optional[String] = Optional.Absent,
    password: Optional[SecretString] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent,
    serverName: Optional[String] = Optional.Absent,
    setDataCaptureChanges: Optional[BooleanOptional] = Optional.Absent,
    currentLsn: Optional[String] = Optional.Absent,
    maxKBytesPerRead: Optional[IntegerOptional] = Optional.Absent,
    username: Optional[String] = Optional.Absent,
    secretsManagerAccessRoleArn: Optional[String] = Optional.Absent,
    secretsManagerSecretId: Optional[String] = Optional.Absent,
    loadTimeout: Optional[IntegerOptional] = Optional.Absent,
    writeBufferSize: Optional[IntegerOptional] = Optional.Absent,
    maxFileSize: Optional[IntegerOptional] = Optional.Absent,
    keepCsvFiles: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.IBMDb2Settings = {
    import IBMDb2Settings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.IBMDb2Settings
      .builder()
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .optionallyWith(
        password.map(value => SecretString.unwrap(value): java.lang.String)
      )(_.password)
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(serverName.map(value => value: java.lang.String))(
        _.serverName
      )
      .optionallyWith(
        setDataCaptureChanges.map(value => value: java.lang.Boolean)
      )(_.setDataCaptureChanges)
      .optionallyWith(currentLsn.map(value => value: java.lang.String))(
        _.currentLsn
      )
      .optionallyWith(maxKBytesPerRead.map(value => value: Integer))(
        _.maxKBytesPerRead
      )
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .optionallyWith(
        secretsManagerAccessRoleArn.map(value => value: java.lang.String)
      )(_.secretsManagerAccessRoleArn)
      .optionallyWith(
        secretsManagerSecretId.map(value => value: java.lang.String)
      )(_.secretsManagerSecretId)
      .optionallyWith(loadTimeout.map(value => value: Integer))(_.loadTimeout)
      .optionallyWith(writeBufferSize.map(value => value: Integer))(
        _.writeBufferSize
      )
      .optionallyWith(maxFileSize.map(value => value: Integer))(_.maxFileSize)
      .optionallyWith(keepCsvFiles.map(value => value: java.lang.Boolean))(
        _.keepCsvFiles
      )
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.IBMDb2Settings.ReadOnly =
    zio.aws.databasemigration.model.IBMDb2Settings.wrap(buildAwsValue())
}
object IBMDb2Settings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.IBMDb2Settings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.IBMDb2Settings =
      zio.aws.databasemigration.model.IBMDb2Settings(
        databaseName.map(value => value),
        password.map(value => value),
        port.map(value => value),
        serverName.map(value => value),
        setDataCaptureChanges.map(value => value),
        currentLsn.map(value => value),
        maxKBytesPerRead.map(value => value),
        username.map(value => value),
        secretsManagerAccessRoleArn.map(value => value),
        secretsManagerSecretId.map(value => value),
        loadTimeout.map(value => value),
        writeBufferSize.map(value => value),
        maxFileSize.map(value => value),
        keepCsvFiles.map(value => value)
      )
    def databaseName: Optional[String]
    def password: Optional[SecretString]
    def port: Optional[IntegerOptional]
    def serverName: Optional[String]
    def setDataCaptureChanges: Optional[BooleanOptional]
    def currentLsn: Optional[String]
    def maxKBytesPerRead: Optional[IntegerOptional]
    def username: Optional[String]
    def secretsManagerAccessRoleArn: Optional[String]
    def secretsManagerSecretId: Optional[String]
    def loadTimeout: Optional[IntegerOptional]
    def writeBufferSize: Optional[IntegerOptional]
    def maxFileSize: Optional[IntegerOptional]
    def keepCsvFiles: Optional[BooleanOptional]
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getPassword: ZIO[Any, AwsError, SecretString] =
      AwsError.unwrapOptionField("password", password)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getServerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverName", serverName)
    def getSetDataCaptureChanges: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("setDataCaptureChanges", setDataCaptureChanges)
    def getCurrentLsn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("currentLsn", currentLsn)
    def getMaxKBytesPerRead: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxKBytesPerRead", maxKBytesPerRead)
    def getUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("username", username)
    def getSecretsManagerAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "secretsManagerAccessRoleArn",
        secretsManagerAccessRoleArn
      )
    def getSecretsManagerSecretId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("secretsManagerSecretId", secretsManagerSecretId)
    def getLoadTimeout: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("loadTimeout", loadTimeout)
    def getWriteBufferSize: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("writeBufferSize", writeBufferSize)
    def getMaxFileSize: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxFileSize", maxFileSize)
    def getKeepCsvFiles: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("keepCsvFiles", keepCsvFiles)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.IBMDb2Settings
  ) extends zio.aws.databasemigration.model.IBMDb2Settings.ReadOnly {
    override val databaseName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value => value: String)
    override val password: Optional[SecretString] = zio.aws.core.internal
      .optionalFromNullable(impl.password())
      .map(value =>
        zio.aws.databasemigration.model.primitives.SecretString(value)
      )
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val serverName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serverName())
      .map(value => value: String)
    override val setDataCaptureChanges: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.setDataCaptureChanges())
        .map(value => value: BooleanOptional)
    override val currentLsn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.currentLsn())
      .map(value => value: String)
    override val maxKBytesPerRead: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxKBytesPerRead())
        .map(value => value: IntegerOptional)
    override val username: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.username())
      .map(value => value: String)
    override val secretsManagerAccessRoleArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretsManagerAccessRoleArn())
        .map(value => value: String)
    override val secretsManagerSecretId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretsManagerSecretId())
        .map(value => value: String)
    override val loadTimeout: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.loadTimeout())
      .map(value => value: IntegerOptional)
    override val writeBufferSize: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.writeBufferSize())
        .map(value => value: IntegerOptional)
    override val maxFileSize: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxFileSize())
      .map(value => value: IntegerOptional)
    override val keepCsvFiles: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.keepCsvFiles())
      .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.IBMDb2Settings
  ): zio.aws.databasemigration.model.IBMDb2Settings.ReadOnly = new Wrapper(impl)
}
