package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ErrorDetails(
    defaultErrorDetails: Optional[
      zio.aws.databasemigration.model.DefaultErrorDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ErrorDetails = {
    import ErrorDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ErrorDetails
      .builder()
      .optionallyWith(defaultErrorDetails.map(value => value.buildAwsValue()))(
        _.defaultErrorDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.ErrorDetails.ReadOnly =
    zio.aws.databasemigration.model.ErrorDetails.wrap(buildAwsValue())
}
object ErrorDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ErrorDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.ErrorDetails =
      zio.aws.databasemigration.model
        .ErrorDetails(defaultErrorDetails.map(value => value.asEditable))
    def defaultErrorDetails
        : Optional[zio.aws.databasemigration.model.DefaultErrorDetails.ReadOnly]
    def getDefaultErrorDetails: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.DefaultErrorDetails.ReadOnly
    ] = AwsError.unwrapOptionField("defaultErrorDetails", defaultErrorDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ErrorDetails
  ) extends zio.aws.databasemigration.model.ErrorDetails.ReadOnly {
    override val defaultErrorDetails: Optional[
      zio.aws.databasemigration.model.DefaultErrorDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultErrorDetails())
      .map(value =>
        zio.aws.databasemigration.model.DefaultErrorDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ErrorDetails
  ): zio.aws.databasemigration.model.ErrorDetails.ReadOnly = new Wrapper(impl)
}
