package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.TStamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class EngineVersion(
    version: Optional[String] = Optional.Absent,
    lifecycle: Optional[String] = Optional.Absent,
    releaseStatus: Optional[
      zio.aws.databasemigration.model.ReleaseStatusValues
    ] = Optional.Absent,
    launchDate: Optional[TStamp] = Optional.Absent,
    autoUpgradeDate: Optional[TStamp] = Optional.Absent,
    deprecationDate: Optional[TStamp] = Optional.Absent,
    forceUpgradeDate: Optional[TStamp] = Optional.Absent,
    availableUpgrades: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.EngineVersion = {
    import EngineVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.EngineVersion
      .builder()
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .optionallyWith(lifecycle.map(value => value: java.lang.String))(
        _.lifecycle
      )
      .optionallyWith(releaseStatus.map(value => value.unwrap))(_.releaseStatus)
      .optionallyWith(launchDate.map(value => TStamp.unwrap(value): Instant))(
        _.launchDate
      )
      .optionallyWith(
        autoUpgradeDate.map(value => TStamp.unwrap(value): Instant)
      )(_.autoUpgradeDate)
      .optionallyWith(
        deprecationDate.map(value => TStamp.unwrap(value): Instant)
      )(_.deprecationDate)
      .optionallyWith(
        forceUpgradeDate.map(value => TStamp.unwrap(value): Instant)
      )(_.forceUpgradeDate)
      .optionallyWith(
        availableUpgrades.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.availableUpgrades)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.EngineVersion.ReadOnly =
    zio.aws.databasemigration.model.EngineVersion.wrap(buildAwsValue())
}
object EngineVersion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.EngineVersion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.EngineVersion =
      zio.aws.databasemigration.model.EngineVersion(
        version.map(value => value),
        lifecycle.map(value => value),
        releaseStatus.map(value => value),
        launchDate.map(value => value),
        autoUpgradeDate.map(value => value),
        deprecationDate.map(value => value),
        forceUpgradeDate.map(value => value),
        availableUpgrades.map(value => value)
      )
    def version: Optional[String]
    def lifecycle: Optional[String]
    def releaseStatus
        : Optional[zio.aws.databasemigration.model.ReleaseStatusValues]
    def launchDate: Optional[TStamp]
    def autoUpgradeDate: Optional[TStamp]
    def deprecationDate: Optional[TStamp]
    def forceUpgradeDate: Optional[TStamp]
    def availableUpgrades: Optional[List[String]]
    def getVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", version)
    def getLifecycle: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lifecycle", lifecycle)
    def getReleaseStatus: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ReleaseStatusValues
    ] = AwsError.unwrapOptionField("releaseStatus", releaseStatus)
    def getLaunchDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("launchDate", launchDate)
    def getAutoUpgradeDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("autoUpgradeDate", autoUpgradeDate)
    def getDeprecationDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("deprecationDate", deprecationDate)
    def getForceUpgradeDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("forceUpgradeDate", forceUpgradeDate)
    def getAvailableUpgrades: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("availableUpgrades", availableUpgrades)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.EngineVersion
  ) extends zio.aws.databasemigration.model.EngineVersion.ReadOnly {
    override val version: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: String)
    override val lifecycle: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lifecycle())
      .map(value => value: String)
    override val releaseStatus
        : Optional[zio.aws.databasemigration.model.ReleaseStatusValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.releaseStatus())
        .map(value =>
          zio.aws.databasemigration.model.ReleaseStatusValues.wrap(value)
        )
    override val launchDate: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.launchDate())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val autoUpgradeDate: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.autoUpgradeDate())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val deprecationDate: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.deprecationDate())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val forceUpgradeDate: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.forceUpgradeDate())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val availableUpgrades: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availableUpgrades())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.EngineVersion
  ): zio.aws.databasemigration.model.EngineVersion.ReadOnly = new Wrapper(impl)
}
