package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeTableStatisticsResponse(
    replicationTaskArn: Optional[String] = Optional.Absent,
    tableStatistics: Optional[
      Iterable[zio.aws.databasemigration.model.TableStatistics]
    ] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsResponse = {
    import DescribeTableStatisticsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsResponse
      .builder()
      .optionallyWith(replicationTaskArn.map(value => value: java.lang.String))(
        _.replicationTaskArn
      )
      .optionallyWith(
        tableStatistics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tableStatistics)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeTableStatisticsResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeTableStatisticsResponse
      .wrap(buildAwsValue())
}
object DescribeTableStatisticsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeTableStatisticsResponse =
      zio.aws.databasemigration.model.DescribeTableStatisticsResponse(
        replicationTaskArn.map(value => value),
        tableStatistics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def replicationTaskArn: Optional[String]
    def tableStatistics: Optional[
      List[zio.aws.databasemigration.model.TableStatistics.ReadOnly]
    ]
    def marker: Optional[String]
    def getReplicationTaskArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationTaskArn", replicationTaskArn)
    def getTableStatistics: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.TableStatistics.ReadOnly
    ]] = AwsError.unwrapOptionField("tableStatistics", tableStatistics)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsResponse
  ) extends zio.aws.databasemigration.model.DescribeTableStatisticsResponse.ReadOnly {
    override val replicationTaskArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationTaskArn())
      .map(value => value: String)
    override val tableStatistics: Optional[
      List[zio.aws.databasemigration.model.TableStatistics.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tableStatistics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.TableStatistics.wrap(item)
        }.toList
      )
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsResponse
  ): zio.aws.databasemigration.model.DescribeTableStatisticsResponse.ReadOnly =
    new Wrapper(impl)
}
