package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeReplicationTaskAssessmentResultsResponse(
    marker: Optional[String] = Optional.Absent,
    bucketName: Optional[String] = Optional.Absent,
    replicationTaskAssessmentResults: Optional[
      Iterable[zio.aws.databasemigration.model.ReplicationTaskAssessmentResult]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse = {
    import DescribeReplicationTaskAssessmentResultsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(bucketName.map(value => value: java.lang.String))(
        _.bucketName
      )
      .optionallyWith(
        replicationTaskAssessmentResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicationTaskAssessmentResults)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse
      .wrap(buildAwsValue())
}
object DescribeReplicationTaskAssessmentResultsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse =
      zio.aws.databasemigration.model
        .DescribeReplicationTaskAssessmentResultsResponse(
          marker.map(value => value),
          bucketName.map(value => value),
          replicationTaskAssessmentResults.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def marker: Optional[String]
    def bucketName: Optional[String]
    def replicationTaskAssessmentResults: Optional[List[
      zio.aws.databasemigration.model.ReplicationTaskAssessmentResult.ReadOnly
    ]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getBucketName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bucketName", bucketName)
    def getReplicationTaskAssessmentResults: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.ReplicationTaskAssessmentResult.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "replicationTaskAssessmentResults",
      replicationTaskAssessmentResults
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse
  ) extends zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val bucketName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketName())
      .map(value => value: String)
    override val replicationTaskAssessmentResults: Optional[List[
      zio.aws.databasemigration.model.ReplicationTaskAssessmentResult.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationTaskAssessmentResults())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.ReplicationTaskAssessmentResult
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse
  ): zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse.ReadOnly =
    new Wrapper(impl)
}
