package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.IntegerOptional
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeReplicationTableStatisticsRequest(
    replicationConfigArn: String,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.databasemigration.model.Filter]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsRequest = {
    import DescribeReplicationTableStatisticsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsRequest
      .builder()
      .replicationConfigArn(replicationConfigArn: java.lang.String)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeReplicationTableStatisticsRequest.ReadOnly =
    zio.aws.databasemigration.model.DescribeReplicationTableStatisticsRequest
      .wrap(buildAwsValue())
}
object DescribeReplicationTableStatisticsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeReplicationTableStatisticsRequest =
      zio.aws.databasemigration.model.DescribeReplicationTableStatisticsRequest(
        replicationConfigArn,
        maxRecords.map(value => value),
        marker.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def replicationConfigArn: String
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def filters: Optional[List[zio.aws.databasemigration.model.Filter.ReadOnly]]
    def getReplicationConfigArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationConfigArn)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.Filter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsRequest
  ) extends zio.aws.databasemigration.model.DescribeReplicationTableStatisticsRequest.ReadOnly {
    override val replicationConfigArn: String =
      impl.replicationConfigArn(): String
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val filters
        : Optional[List[zio.aws.databasemigration.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databasemigration.model.Filter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsRequest
  ): zio.aws.databasemigration.model.DescribeReplicationTableStatisticsRequest.ReadOnly =
    new Wrapper(impl)
}
