package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.IntegerOptional
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeReplicationInstanceTaskLogsRequest(
    replicationInstanceArn: String,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest = {
    import DescribeReplicationInstanceTaskLogsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest
      .builder()
      .replicationInstanceArn(replicationInstanceArn: java.lang.String)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest.ReadOnly =
    zio.aws.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest
      .wrap(buildAwsValue())
}
object DescribeReplicationInstanceTaskLogsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest =
      zio.aws.databasemigration.model
        .DescribeReplicationInstanceTaskLogsRequest(
          replicationInstanceArn,
          maxRecords.map(value => value),
          marker.map(value => value)
        )
    def replicationInstanceArn: String
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def getReplicationInstanceArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationInstanceArn)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest
  ) extends zio.aws.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest.ReadOnly {
    override val replicationInstanceArn: String =
      impl.replicationInstanceArn(): String
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest
  ): zio.aws.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest.ReadOnly =
    new Wrapper(impl)
}
