package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeReplicationConfigsResponse(
    marker: Optional[String] = Optional.Absent,
    replicationConfigs: Optional[
      Iterable[zio.aws.databasemigration.model.ReplicationConfig]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeReplicationConfigsResponse = {
    import DescribeReplicationConfigsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeReplicationConfigsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        replicationConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicationConfigs)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeReplicationConfigsResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeReplicationConfigsResponse
      .wrap(buildAwsValue())
}
object DescribeReplicationConfigsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeReplicationConfigsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeReplicationConfigsResponse =
      zio.aws.databasemigration.model.DescribeReplicationConfigsResponse(
        marker.map(value => value),
        replicationConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def replicationConfigs: Optional[
      List[zio.aws.databasemigration.model.ReplicationConfig.ReadOnly]
    ]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getReplicationConfigs: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.ReplicationConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("replicationConfigs", replicationConfigs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeReplicationConfigsResponse
  ) extends zio.aws.databasemigration.model.DescribeReplicationConfigsResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val replicationConfigs: Optional[
      List[zio.aws.databasemigration.model.ReplicationConfig.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationConfigs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.ReplicationConfig.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeReplicationConfigsResponse
  ): zio.aws.databasemigration.model.DescribeReplicationConfigsResponse.ReadOnly =
    new Wrapper(impl)
}
