package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.IntegerOptional
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeOrderableReplicationInstancesRequest(
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest = {
    import DescribeOrderableReplicationInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest
      .builder()
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeOrderableReplicationInstancesRequest.ReadOnly =
    zio.aws.databasemigration.model.DescribeOrderableReplicationInstancesRequest
      .wrap(buildAwsValue())
}
object DescribeOrderableReplicationInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeOrderableReplicationInstancesRequest =
      zio.aws.databasemigration.model
        .DescribeOrderableReplicationInstancesRequest(
          maxRecords.map(value => value),
          marker.map(value => value)
        )
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest
  ) extends zio.aws.databasemigration.model.DescribeOrderableReplicationInstancesRequest.ReadOnly {
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest
  ): zio.aws.databasemigration.model.DescribeOrderableReplicationInstancesRequest.ReadOnly =
    new Wrapper(impl)
}
