package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeMetadataModelExportsToTargetResponse(
    marker: Optional[String] = Optional.Absent,
    requests: Optional[
      Iterable[zio.aws.databasemigration.model.SchemaConversionRequest]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsToTargetResponse = {
    import DescribeMetadataModelExportsToTargetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsToTargetResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        requests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.requests)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeMetadataModelExportsToTargetResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeMetadataModelExportsToTargetResponse
      .wrap(buildAwsValue())
}
object DescribeMetadataModelExportsToTargetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsToTargetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeMetadataModelExportsToTargetResponse =
      zio.aws.databasemigration.model
        .DescribeMetadataModelExportsToTargetResponse(
          marker.map(value => value),
          requests.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def marker: Optional[String]
    def requests: Optional[
      List[zio.aws.databasemigration.model.SchemaConversionRequest.ReadOnly]
    ]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getRequests: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.SchemaConversionRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("requests", requests)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsToTargetResponse
  ) extends zio.aws.databasemigration.model.DescribeMetadataModelExportsToTargetResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val requests: Optional[
      List[zio.aws.databasemigration.model.SchemaConversionRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.requests())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.SchemaConversionRequest.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsToTargetResponse
  ): zio.aws.databasemigration.model.DescribeMetadataModelExportsToTargetResponse.ReadOnly =
    new Wrapper(impl)
}
