package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeMetadataModelConversionsResponse(
    marker: Optional[String] = Optional.Absent,
    requests: Optional[
      Iterable[zio.aws.databasemigration.model.SchemaConversionRequest]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelConversionsResponse = {
    import DescribeMetadataModelConversionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelConversionsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        requests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.requests)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeMetadataModelConversionsResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeMetadataModelConversionsResponse
      .wrap(buildAwsValue())
}
object DescribeMetadataModelConversionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelConversionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeMetadataModelConversionsResponse =
      zio.aws.databasemigration.model.DescribeMetadataModelConversionsResponse(
        marker.map(value => value),
        requests.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def requests: Optional[
      List[zio.aws.databasemigration.model.SchemaConversionRequest.ReadOnly]
    ]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getRequests: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.SchemaConversionRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("requests", requests)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelConversionsResponse
  ) extends zio.aws.databasemigration.model.DescribeMetadataModelConversionsResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val requests: Optional[
      List[zio.aws.databasemigration.model.SchemaConversionRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.requests())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.SchemaConversionRequest.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelConversionsResponse
  ): zio.aws.databasemigration.model.DescribeMetadataModelConversionsResponse.ReadOnly =
    new Wrapper(impl)
}
