package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeInstanceProfilesResponse(
    marker: Optional[String] = Optional.Absent,
    instanceProfiles: Optional[
      Iterable[zio.aws.databasemigration.model.InstanceProfile]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeInstanceProfilesResponse = {
    import DescribeInstanceProfilesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeInstanceProfilesResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        instanceProfiles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceProfiles)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeInstanceProfilesResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeInstanceProfilesResponse
      .wrap(buildAwsValue())
}
object DescribeInstanceProfilesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeInstanceProfilesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeInstanceProfilesResponse =
      zio.aws.databasemigration.model.DescribeInstanceProfilesResponse(
        marker.map(value => value),
        instanceProfiles.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def instanceProfiles: Optional[
      List[zio.aws.databasemigration.model.InstanceProfile.ReadOnly]
    ]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getInstanceProfiles: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.InstanceProfile.ReadOnly
    ]] = AwsError.unwrapOptionField("instanceProfiles", instanceProfiles)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeInstanceProfilesResponse
  ) extends zio.aws.databasemigration.model.DescribeInstanceProfilesResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val instanceProfiles: Optional[
      List[zio.aws.databasemigration.model.InstanceProfile.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceProfiles())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.InstanceProfile.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeInstanceProfilesResponse
  ): zio.aws.databasemigration.model.DescribeInstanceProfilesResponse.ReadOnly =
    new Wrapper(impl)
}
