package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeFleetAdvisorSchemasResponse(
    fleetAdvisorSchemas: Optional[
      Iterable[zio.aws.databasemigration.model.SchemaResponse]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemasResponse = {
    import DescribeFleetAdvisorSchemasResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemasResponse
      .builder()
      .optionallyWith(
        fleetAdvisorSchemas.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fleetAdvisorSchemas)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeFleetAdvisorSchemasResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeFleetAdvisorSchemasResponse
      .wrap(buildAwsValue())
}
object DescribeFleetAdvisorSchemasResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemasResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeFleetAdvisorSchemasResponse =
      zio.aws.databasemigration.model.DescribeFleetAdvisorSchemasResponse(
        fleetAdvisorSchemas.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def fleetAdvisorSchemas: Optional[
      List[zio.aws.databasemigration.model.SchemaResponse.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getFleetAdvisorSchemas: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.SchemaResponse.ReadOnly
    ]] = AwsError.unwrapOptionField("fleetAdvisorSchemas", fleetAdvisorSchemas)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemasResponse
  ) extends zio.aws.databasemigration.model.DescribeFleetAdvisorSchemasResponse.ReadOnly {
    override val fleetAdvisorSchemas: Optional[
      List[zio.aws.databasemigration.model.SchemaResponse.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetAdvisorSchemas())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.SchemaResponse.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemasResponse
  ): zio.aws.databasemigration.model.DescribeFleetAdvisorSchemasResponse.ReadOnly =
    new Wrapper(impl)
}
