package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.IntegerOptional
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeFleetAdvisorSchemasRequest(
    filters: Optional[Iterable[zio.aws.databasemigration.model.Filter]] =
      Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemasRequest = {
    import DescribeFleetAdvisorSchemasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemasRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeFleetAdvisorSchemasRequest.ReadOnly =
    zio.aws.databasemigration.model.DescribeFleetAdvisorSchemasRequest
      .wrap(buildAwsValue())
}
object DescribeFleetAdvisorSchemasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeFleetAdvisorSchemasRequest =
      zio.aws.databasemigration.model.DescribeFleetAdvisorSchemasRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxRecords.map(value => value),
        nextToken.map(value => value)
      )
    def filters: Optional[List[zio.aws.databasemigration.model.Filter.ReadOnly]]
    def maxRecords: Optional[IntegerOptional]
    def nextToken: Optional[String]
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.Filter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemasRequest
  ) extends zio.aws.databasemigration.model.DescribeFleetAdvisorSchemasRequest.ReadOnly {
    override val filters
        : Optional[List[zio.aws.databasemigration.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databasemigration.model.Filter.wrap(item)
          }.toList
        )
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemasRequest
  ): zio.aws.databasemigration.model.DescribeFleetAdvisorSchemasRequest.ReadOnly =
    new Wrapper(impl)
}
