package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.IntegerOptional
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeFleetAdvisorLsaAnalysisRequest(
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest = {
    import DescribeFleetAdvisorLsaAnalysisRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest
      .builder()
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest.ReadOnly =
    zio.aws.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest
      .wrap(buildAwsValue())
}
object DescribeFleetAdvisorLsaAnalysisRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest =
      zio.aws.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest(
        maxRecords.map(value => value),
        nextToken.map(value => value)
      )
    def maxRecords: Optional[IntegerOptional]
    def nextToken: Optional[String]
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest
  ) extends zio.aws.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest.ReadOnly {
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest
  ): zio.aws.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest.ReadOnly =
    new Wrapper(impl)
}
