package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeFleetAdvisorDatabasesResponse(
    databases: Optional[
      Iterable[zio.aws.databasemigration.model.DatabaseResponse]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorDatabasesResponse = {
    import DescribeFleetAdvisorDatabasesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorDatabasesResponse
      .builder()
      .optionallyWith(
        databases.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.databases)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeFleetAdvisorDatabasesResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeFleetAdvisorDatabasesResponse
      .wrap(buildAwsValue())
}
object DescribeFleetAdvisorDatabasesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorDatabasesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeFleetAdvisorDatabasesResponse =
      zio.aws.databasemigration.model.DescribeFleetAdvisorDatabasesResponse(
        databases.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def databases: Optional[
      List[zio.aws.databasemigration.model.DatabaseResponse.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getDatabases: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.DatabaseResponse.ReadOnly
    ]] = AwsError.unwrapOptionField("databases", databases)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorDatabasesResponse
  ) extends zio.aws.databasemigration.model.DescribeFleetAdvisorDatabasesResponse.ReadOnly {
    override val databases: Optional[
      List[zio.aws.databasemigration.model.DatabaseResponse.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.databases())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.DatabaseResponse.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorDatabasesResponse
  ): zio.aws.databasemigration.model.DescribeFleetAdvisorDatabasesResponse.ReadOnly =
    new Wrapper(impl)
}
