package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeDataProvidersResponse(
    marker: Optional[String] = Optional.Absent,
    dataProviders: Optional[
      Iterable[zio.aws.databasemigration.model.DataProvider]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeDataProvidersResponse = {
    import DescribeDataProvidersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeDataProvidersResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        dataProviders.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataProviders)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeDataProvidersResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeDataProvidersResponse
      .wrap(buildAwsValue())
}
object DescribeDataProvidersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeDataProvidersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeDataProvidersResponse =
      zio.aws.databasemigration.model.DescribeDataProvidersResponse(
        marker.map(value => value),
        dataProviders.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def dataProviders
        : Optional[List[zio.aws.databasemigration.model.DataProvider.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getDataProviders: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.DataProvider.ReadOnly
    ]] = AwsError.unwrapOptionField("dataProviders", dataProviders)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeDataProvidersResponse
  ) extends zio.aws.databasemigration.model.DescribeDataProvidersResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val dataProviders: Optional[
      List[zio.aws.databasemigration.model.DataProvider.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataProviders())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.DataProvider.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeDataProvidersResponse
  ): zio.aws.databasemigration.model.DescribeDataProvidersResponse.ReadOnly =
    new Wrapper(impl)
}
