package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.databasemigration.model.primitives.Marker
import scala.jdk.CollectionConverters.*
final case class DescribeDataMigrationsResponse(
    dataMigrations: Optional[
      Iterable[zio.aws.databasemigration.model.DataMigration]
    ] = Optional.Absent,
    marker: Optional[Marker] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsResponse = {
    import DescribeDataMigrationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsResponse
      .builder()
      .optionallyWith(
        dataMigrations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataMigrations)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeDataMigrationsResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeDataMigrationsResponse
      .wrap(buildAwsValue())
}
object DescribeDataMigrationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeDataMigrationsResponse =
      zio.aws.databasemigration.model.DescribeDataMigrationsResponse(
        dataMigrations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def dataMigrations
        : Optional[List[zio.aws.databasemigration.model.DataMigration.ReadOnly]]
    def marker: Optional[Marker]
    def getDataMigrations: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.DataMigration.ReadOnly
    ]] = AwsError.unwrapOptionField("dataMigrations", dataMigrations)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsResponse
  ) extends zio.aws.databasemigration.model.DescribeDataMigrationsResponse.ReadOnly {
    override val dataMigrations: Optional[
      List[zio.aws.databasemigration.model.DataMigration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataMigrations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.DataMigration.wrap(item)
        }.toList
      )
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.databasemigration.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsResponse
  ): zio.aws.databasemigration.model.DescribeDataMigrationsResponse.ReadOnly =
    new Wrapper(impl)
}
