package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.{
  BooleanOptional,
  Marker,
  IntegerOptional
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeDataMigrationsRequest(
    filters: Optional[Iterable[zio.aws.databasemigration.model.Filter]] =
      Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[Marker] = Optional.Absent,
    withoutSettings: Optional[BooleanOptional] = Optional.Absent,
    withoutStatistics: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsRequest = {
    import DescribeDataMigrationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(withoutSettings.map(value => value: java.lang.Boolean))(
        _.withoutSettings
      )
      .optionallyWith(withoutStatistics.map(value => value: java.lang.Boolean))(
        _.withoutStatistics
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeDataMigrationsRequest.ReadOnly =
    zio.aws.databasemigration.model.DescribeDataMigrationsRequest
      .wrap(buildAwsValue())
}
object DescribeDataMigrationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeDataMigrationsRequest =
      zio.aws.databasemigration.model.DescribeDataMigrationsRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxRecords.map(value => value),
        marker.map(value => value),
        withoutSettings.map(value => value),
        withoutStatistics.map(value => value)
      )
    def filters: Optional[List[zio.aws.databasemigration.model.Filter.ReadOnly]]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[Marker]
    def withoutSettings: Optional[BooleanOptional]
    def withoutStatistics: Optional[BooleanOptional]
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.Filter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getWithoutSettings: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("withoutSettings", withoutSettings)
    def getWithoutStatistics: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("withoutStatistics", withoutStatistics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsRequest
  ) extends zio.aws.databasemigration.model.DescribeDataMigrationsRequest.ReadOnly {
    override val filters
        : Optional[List[zio.aws.databasemigration.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databasemigration.model.Filter.wrap(item)
          }.toList
        )
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.databasemigration.model.primitives.Marker(value))
    override val withoutSettings: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.withoutSettings())
        .map(value => value: BooleanOptional)
    override val withoutStatistics: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.withoutStatistics())
        .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsRequest
  ): zio.aws.databasemigration.model.DescribeDataMigrationsRequest.ReadOnly =
    new Wrapper(impl)
}
