package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeApplicableIndividualAssessmentsResponse(
    individualAssessmentNames: Optional[Iterable[String]] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse = {
    import DescribeApplicableIndividualAssessmentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse
      .builder()
      .optionallyWith(
        individualAssessmentNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.individualAssessmentNames)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse
      .wrap(buildAwsValue())
}
object DescribeApplicableIndividualAssessmentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse =
      zio.aws.databasemigration.model
        .DescribeApplicableIndividualAssessmentsResponse(
          individualAssessmentNames.map(value => value),
          marker.map(value => value)
        )
    def individualAssessmentNames: Optional[List[String]]
    def marker: Optional[String]
    def getIndividualAssessmentNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "individualAssessmentNames",
        individualAssessmentNames
      )
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse
  ) extends zio.aws.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse.ReadOnly {
    override val individualAssessmentNames: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.individualAssessmentNames())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse
  ): zio.aws.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse.ReadOnly =
    new Wrapper(impl)
}
