package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.IntegerOptional
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeApplicableIndividualAssessmentsRequest(
    replicationTaskArn: Optional[String] = Optional.Absent,
    replicationInstanceArn: Optional[String] = Optional.Absent,
    sourceEngineName: Optional[String] = Optional.Absent,
    targetEngineName: Optional[String] = Optional.Absent,
    migrationType: Optional[
      zio.aws.databasemigration.model.MigrationTypeValue
    ] = Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest = {
    import DescribeApplicableIndividualAssessmentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest
      .builder()
      .optionallyWith(replicationTaskArn.map(value => value: java.lang.String))(
        _.replicationTaskArn
      )
      .optionallyWith(
        replicationInstanceArn.map(value => value: java.lang.String)
      )(_.replicationInstanceArn)
      .optionallyWith(sourceEngineName.map(value => value: java.lang.String))(
        _.sourceEngineName
      )
      .optionallyWith(targetEngineName.map(value => value: java.lang.String))(
        _.targetEngineName
      )
      .optionallyWith(migrationType.map(value => value.unwrap))(_.migrationType)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest.ReadOnly =
    zio.aws.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest
      .wrap(buildAwsValue())
}
object DescribeApplicableIndividualAssessmentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest =
      zio.aws.databasemigration.model
        .DescribeApplicableIndividualAssessmentsRequest(
          replicationTaskArn.map(value => value),
          replicationInstanceArn.map(value => value),
          sourceEngineName.map(value => value),
          targetEngineName.map(value => value),
          migrationType.map(value => value),
          maxRecords.map(value => value),
          marker.map(value => value)
        )
    def replicationTaskArn: Optional[String]
    def replicationInstanceArn: Optional[String]
    def sourceEngineName: Optional[String]
    def targetEngineName: Optional[String]
    def migrationType
        : Optional[zio.aws.databasemigration.model.MigrationTypeValue]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def getReplicationTaskArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationTaskArn", replicationTaskArn)
    def getReplicationInstanceArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationInstanceArn", replicationInstanceArn)
    def getSourceEngineName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceEngineName", sourceEngineName)
    def getTargetEngineName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetEngineName", targetEngineName)
    def getMigrationType: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.MigrationTypeValue
    ] = AwsError.unwrapOptionField("migrationType", migrationType)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest
  ) extends zio.aws.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest.ReadOnly {
    override val replicationTaskArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationTaskArn())
      .map(value => value: String)
    override val replicationInstanceArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationInstanceArn())
        .map(value => value: String)
    override val sourceEngineName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceEngineName())
      .map(value => value: String)
    override val targetEngineName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.targetEngineName())
      .map(value => value: String)
    override val migrationType
        : Optional[zio.aws.databasemigration.model.MigrationTypeValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.migrationType())
        .map(value =>
          zio.aws.databasemigration.model.MigrationTypeValue.wrap(value)
        )
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest
  ): zio.aws.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest.ReadOnly =
    new Wrapper(impl)
}
