package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteMigrationProjectResponse(
    migrationProject: Optional[
      zio.aws.databasemigration.model.MigrationProject
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DeleteMigrationProjectResponse = {
    import DeleteMigrationProjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DeleteMigrationProjectResponse
      .builder()
      .optionallyWith(migrationProject.map(value => value.buildAwsValue()))(
        _.migrationProject
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DeleteMigrationProjectResponse.ReadOnly =
    zio.aws.databasemigration.model.DeleteMigrationProjectResponse
      .wrap(buildAwsValue())
}
object DeleteMigrationProjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DeleteMigrationProjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DeleteMigrationProjectResponse =
      zio.aws.databasemigration.model.DeleteMigrationProjectResponse(
        migrationProject.map(value => value.asEditable)
      )
    def migrationProject
        : Optional[zio.aws.databasemigration.model.MigrationProject.ReadOnly]
    def getMigrationProject: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.MigrationProject.ReadOnly
    ] = AwsError.unwrapOptionField("migrationProject", migrationProject)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteMigrationProjectResponse
  ) extends zio.aws.databasemigration.model.DeleteMigrationProjectResponse.ReadOnly {
    override val migrationProject
        : Optional[zio.aws.databasemigration.model.MigrationProject.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.migrationProject())
        .map(value =>
          zio.aws.databasemigration.model.MigrationProject.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteMigrationProjectResponse
  ): zio.aws.databasemigration.model.DeleteMigrationProjectResponse.ReadOnly =
    new Wrapper(impl)
}
