package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteDataMigrationResponse(
    dataMigration: Optional[zio.aws.databasemigration.model.DataMigration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DeleteDataMigrationResponse = {
    import DeleteDataMigrationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DeleteDataMigrationResponse
      .builder()
      .optionallyWith(dataMigration.map(value => value.buildAwsValue()))(
        _.dataMigration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DeleteDataMigrationResponse.ReadOnly =
    zio.aws.databasemigration.model.DeleteDataMigrationResponse
      .wrap(buildAwsValue())
}
object DeleteDataMigrationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DeleteDataMigrationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DeleteDataMigrationResponse =
      zio.aws.databasemigration.model.DeleteDataMigrationResponse(
        dataMigration.map(value => value.asEditable)
      )
    def dataMigration
        : Optional[zio.aws.databasemigration.model.DataMigration.ReadOnly]
    def getDataMigration: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.DataMigration.ReadOnly
    ] = AwsError.unwrapOptionField("dataMigration", dataMigration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteDataMigrationResponse
  ) extends zio.aws.databasemigration.model.DeleteDataMigrationResponse.ReadOnly {
    override val dataMigration
        : Optional[zio.aws.databasemigration.model.DataMigration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataMigration())
        .map(value => zio.aws.databasemigration.model.DataMigration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteDataMigrationResponse
  ): zio.aws.databasemigration.model.DeleteDataMigrationResponse.ReadOnly =
    new Wrapper(impl)
}
