package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteDataMigrationRequest(dataMigrationIdentifier: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DeleteDataMigrationRequest = {
    import DeleteDataMigrationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DeleteDataMigrationRequest
      .builder()
      .dataMigrationIdentifier(dataMigrationIdentifier: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DeleteDataMigrationRequest.ReadOnly =
    zio.aws.databasemigration.model.DeleteDataMigrationRequest
      .wrap(buildAwsValue())
}
object DeleteDataMigrationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DeleteDataMigrationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.DeleteDataMigrationRequest =
      zio.aws.databasemigration.model
        .DeleteDataMigrationRequest(dataMigrationIdentifier)
    def dataMigrationIdentifier: String
    def getDataMigrationIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dataMigrationIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteDataMigrationRequest
  ) extends zio.aws.databasemigration.model.DeleteDataMigrationRequest.ReadOnly {
    override val dataMigrationIdentifier: String =
      impl.dataMigrationIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteDataMigrationRequest
  ): zio.aws.databasemigration.model.DeleteDataMigrationRequest.ReadOnly =
    new Wrapper(impl)
}
