package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DefaultErrorDetails(
    message: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DefaultErrorDetails = {
    import DefaultErrorDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DefaultErrorDetails
      .builder()
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.DefaultErrorDetails.ReadOnly =
    zio.aws.databasemigration.model.DefaultErrorDetails.wrap(buildAwsValue())
}
object DefaultErrorDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DefaultErrorDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.DefaultErrorDetails =
      zio.aws.databasemigration.model
        .DefaultErrorDetails(message.map(value => value))
    def message: Optional[String]
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DefaultErrorDetails
  ) extends zio.aws.databasemigration.model.DefaultErrorDetails.ReadOnly {
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DefaultErrorDetails
  ): zio.aws.databasemigration.model.DefaultErrorDetails.ReadOnly = new Wrapper(
    impl
  )
}
