package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.databasemigration.model.primitives.LongOptional
import scala.jdk.CollectionConverters.*
final case class DatabaseResponse(
    databaseId: Optional[String] = Optional.Absent,
    databaseName: Optional[String] = Optional.Absent,
    ipAddress: Optional[String] = Optional.Absent,
    numberOfSchemas: Optional[LongOptional] = Optional.Absent,
    server: Optional[zio.aws.databasemigration.model.ServerShortInfoResponse] =
      Optional.Absent,
    softwareDetails: Optional[
      zio.aws.databasemigration.model.DatabaseInstanceSoftwareDetailsResponse
    ] = Optional.Absent,
    collectors: Optional[
      Iterable[zio.aws.databasemigration.model.CollectorShortInfoResponse]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DatabaseResponse = {
    import DatabaseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DatabaseResponse
      .builder()
      .optionallyWith(databaseId.map(value => value: java.lang.String))(
        _.databaseId
      )
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .optionallyWith(ipAddress.map(value => value: java.lang.String))(
        _.ipAddress
      )
      .optionallyWith(numberOfSchemas.map(value => value: java.lang.Long))(
        _.numberOfSchemas
      )
      .optionallyWith(server.map(value => value.buildAwsValue()))(_.server)
      .optionallyWith(softwareDetails.map(value => value.buildAwsValue()))(
        _.softwareDetails
      )
      .optionallyWith(
        collectors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.collectors)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.DatabaseResponse.ReadOnly =
    zio.aws.databasemigration.model.DatabaseResponse.wrap(buildAwsValue())
}
object DatabaseResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DatabaseResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.DatabaseResponse =
      zio.aws.databasemigration.model.DatabaseResponse(
        databaseId.map(value => value),
        databaseName.map(value => value),
        ipAddress.map(value => value),
        numberOfSchemas.map(value => value),
        server.map(value => value.asEditable),
        softwareDetails.map(value => value.asEditable),
        collectors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def databaseId: Optional[String]
    def databaseName: Optional[String]
    def ipAddress: Optional[String]
    def numberOfSchemas: Optional[LongOptional]
    def server: Optional[
      zio.aws.databasemigration.model.ServerShortInfoResponse.ReadOnly
    ]
    def softwareDetails: Optional[
      zio.aws.databasemigration.model.DatabaseInstanceSoftwareDetailsResponse.ReadOnly
    ]
    def collectors: Optional[
      List[zio.aws.databasemigration.model.CollectorShortInfoResponse.ReadOnly]
    ]
    def getDatabaseId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseId", databaseId)
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getNumberOfSchemas: ZIO[Any, AwsError, LongOptional] =
      AwsError.unwrapOptionField("numberOfSchemas", numberOfSchemas)
    def getServer: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ServerShortInfoResponse.ReadOnly
    ] = AwsError.unwrapOptionField("server", server)
    def getSoftwareDetails: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.DatabaseInstanceSoftwareDetailsResponse.ReadOnly
    ] = AwsError.unwrapOptionField("softwareDetails", softwareDetails)
    def getCollectors: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.CollectorShortInfoResponse.ReadOnly
    ]] = AwsError.unwrapOptionField("collectors", collectors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DatabaseResponse
  ) extends zio.aws.databasemigration.model.DatabaseResponse.ReadOnly {
    override val databaseId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseId())
      .map(value => value: String)
    override val databaseName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value => value: String)
    override val ipAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ipAddress())
      .map(value => value: String)
    override val numberOfSchemas: Optional[LongOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.numberOfSchemas())
      .map(value => value: LongOptional)
    override val server: Optional[
      zio.aws.databasemigration.model.ServerShortInfoResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.server())
      .map(value =>
        zio.aws.databasemigration.model.ServerShortInfoResponse.wrap(value)
      )
    override val softwareDetails: Optional[
      zio.aws.databasemigration.model.DatabaseInstanceSoftwareDetailsResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.softwareDetails())
      .map(value =>
        zio.aws.databasemigration.model.DatabaseInstanceSoftwareDetailsResponse
          .wrap(value)
      )
    override val collectors: Optional[
      List[zio.aws.databasemigration.model.CollectorShortInfoResponse.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.collectors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.CollectorShortInfoResponse.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DatabaseResponse
  ): zio.aws.databasemigration.model.DatabaseResponse.ReadOnly = new Wrapper(
    impl
  )
}
