package zio.aws.databasemigration.model
import scala.jdk.CollectionConverters.*
sealed trait DatabaseMode {
  def unwrap
      : software.amazon.awssdk.services.databasemigration.model.DatabaseMode
}
object DatabaseMode {
  def wrap(
      value: software.amazon.awssdk.services.databasemigration.model.DatabaseMode
  ): zio.aws.databasemigration.model.DatabaseMode = value match {
    case software.amazon.awssdk.services.databasemigration.model.DatabaseMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databasemigration.model.DatabaseMode.DEFAULT =>
      val r = default
      r
    case software.amazon.awssdk.services.databasemigration.model.DatabaseMode.BABELFISH =>
      val r = babelfish
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.databasemigration.model.DatabaseMode {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.DatabaseMode =
      software.amazon.awssdk.services.databasemigration.model.DatabaseMode.UNKNOWN_TO_SDK_VERSION
  }
  case object default extends zio.aws.databasemigration.model.DatabaseMode {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.DatabaseMode =
      software.amazon.awssdk.services.databasemigration.model.DatabaseMode.DEFAULT
  }
  case object babelfish extends zio.aws.databasemigration.model.DatabaseMode {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.DatabaseMode =
      software.amazon.awssdk.services.databasemigration.model.DatabaseMode.BABELFISH
  }
}
