package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DataProviderDescriptorDefinition(
    dataProviderIdentifier: String,
    secretsManagerSecretId: Optional[String] = Optional.Absent,
    secretsManagerAccessRoleArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DataProviderDescriptorDefinition = {
    import DataProviderDescriptorDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DataProviderDescriptorDefinition
      .builder()
      .dataProviderIdentifier(dataProviderIdentifier: java.lang.String)
      .optionallyWith(
        secretsManagerSecretId.map(value => value: java.lang.String)
      )(_.secretsManagerSecretId)
      .optionallyWith(
        secretsManagerAccessRoleArn.map(value => value: java.lang.String)
      )(_.secretsManagerAccessRoleArn)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DataProviderDescriptorDefinition.ReadOnly =
    zio.aws.databasemigration.model.DataProviderDescriptorDefinition
      .wrap(buildAwsValue())
}
object DataProviderDescriptorDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DataProviderDescriptorDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DataProviderDescriptorDefinition =
      zio.aws.databasemigration.model.DataProviderDescriptorDefinition(
        dataProviderIdentifier,
        secretsManagerSecretId.map(value => value),
        secretsManagerAccessRoleArn.map(value => value)
      )
    def dataProviderIdentifier: String
    def secretsManagerSecretId: Optional[String]
    def secretsManagerAccessRoleArn: Optional[String]
    def getDataProviderIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dataProviderIdentifier)
    def getSecretsManagerSecretId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("secretsManagerSecretId", secretsManagerSecretId)
    def getSecretsManagerAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "secretsManagerAccessRoleArn",
        secretsManagerAccessRoleArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DataProviderDescriptorDefinition
  ) extends zio.aws.databasemigration.model.DataProviderDescriptorDefinition.ReadOnly {
    override val dataProviderIdentifier: String =
      impl.dataProviderIdentifier(): String
    override val secretsManagerSecretId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretsManagerSecretId())
        .map(value => value: String)
    override val secretsManagerAccessRoleArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretsManagerAccessRoleArn())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DataProviderDescriptorDefinition
  ): zio.aws.databasemigration.model.DataProviderDescriptorDefinition.ReadOnly =
    new Wrapper(impl)
}
