package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DataProviderDescriptor(
    secretsManagerSecretId: Optional[String] = Optional.Absent,
    secretsManagerAccessRoleArn: Optional[String] = Optional.Absent,
    dataProviderName: Optional[String] = Optional.Absent,
    dataProviderArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DataProviderDescriptor = {
    import DataProviderDescriptor.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DataProviderDescriptor
      .builder()
      .optionallyWith(
        secretsManagerSecretId.map(value => value: java.lang.String)
      )(_.secretsManagerSecretId)
      .optionallyWith(
        secretsManagerAccessRoleArn.map(value => value: java.lang.String)
      )(_.secretsManagerAccessRoleArn)
      .optionallyWith(dataProviderName.map(value => value: java.lang.String))(
        _.dataProviderName
      )
      .optionallyWith(dataProviderArn.map(value => value: java.lang.String))(
        _.dataProviderArn
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DataProviderDescriptor.ReadOnly =
    zio.aws.databasemigration.model.DataProviderDescriptor.wrap(buildAwsValue())
}
object DataProviderDescriptor {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DataProviderDescriptor
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.DataProviderDescriptor =
      zio.aws.databasemigration.model.DataProviderDescriptor(
        secretsManagerSecretId.map(value => value),
        secretsManagerAccessRoleArn.map(value => value),
        dataProviderName.map(value => value),
        dataProviderArn.map(value => value)
      )
    def secretsManagerSecretId: Optional[String]
    def secretsManagerAccessRoleArn: Optional[String]
    def dataProviderName: Optional[String]
    def dataProviderArn: Optional[String]
    def getSecretsManagerSecretId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("secretsManagerSecretId", secretsManagerSecretId)
    def getSecretsManagerAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "secretsManagerAccessRoleArn",
        secretsManagerAccessRoleArn
      )
    def getDataProviderName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataProviderName", dataProviderName)
    def getDataProviderArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataProviderArn", dataProviderArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DataProviderDescriptor
  ) extends zio.aws.databasemigration.model.DataProviderDescriptor.ReadOnly {
    override val secretsManagerSecretId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretsManagerSecretId())
        .map(value => value: String)
    override val secretsManagerAccessRoleArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretsManagerAccessRoleArn())
        .map(value => value: String)
    override val dataProviderName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dataProviderName())
      .map(value => value: String)
    override val dataProviderArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dataProviderArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DataProviderDescriptor
  ): zio.aws.databasemigration.model.DataProviderDescriptor.ReadOnly =
    new Wrapper(impl)
}
