package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.{Iso8601DateTime, Integer}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DataMigrationStatistics(
    tablesLoaded: Optional[Integer] = Optional.Absent,
    elapsedTimeMillis: Optional[Long] = Optional.Absent,
    tablesLoading: Optional[Integer] = Optional.Absent,
    fullLoadPercentage: Optional[Integer] = Optional.Absent,
    cdcLatency: Optional[Integer] = Optional.Absent,
    tablesQueued: Optional[Integer] = Optional.Absent,
    tablesErrored: Optional[Integer] = Optional.Absent,
    startTime: Optional[Iso8601DateTime] = Optional.Absent,
    stopTime: Optional[Iso8601DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DataMigrationStatistics = {
    import DataMigrationStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DataMigrationStatistics
      .builder()
      .optionallyWith(tablesLoaded.map(value => value: java.lang.Integer))(
        _.tablesLoaded
      )
      .optionallyWith(elapsedTimeMillis.map(value => value: java.lang.Long))(
        _.elapsedTimeMillis
      )
      .optionallyWith(tablesLoading.map(value => value: java.lang.Integer))(
        _.tablesLoading
      )
      .optionallyWith(
        fullLoadPercentage.map(value => value: java.lang.Integer)
      )(_.fullLoadPercentage)
      .optionallyWith(cdcLatency.map(value => value: java.lang.Integer))(
        _.cdcLatency
      )
      .optionallyWith(tablesQueued.map(value => value: java.lang.Integer))(
        _.tablesQueued
      )
      .optionallyWith(tablesErrored.map(value => value: java.lang.Integer))(
        _.tablesErrored
      )
      .optionallyWith(
        startTime.map(value => Iso8601DateTime.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(
        stopTime.map(value => Iso8601DateTime.unwrap(value): Instant)
      )(_.stopTime)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DataMigrationStatistics.ReadOnly =
    zio.aws.databasemigration.model.DataMigrationStatistics
      .wrap(buildAwsValue())
}
object DataMigrationStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DataMigrationStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.DataMigrationStatistics =
      zio.aws.databasemigration.model.DataMigrationStatistics(
        tablesLoaded.map(value => value),
        elapsedTimeMillis.map(value => value),
        tablesLoading.map(value => value),
        fullLoadPercentage.map(value => value),
        cdcLatency.map(value => value),
        tablesQueued.map(value => value),
        tablesErrored.map(value => value),
        startTime.map(value => value),
        stopTime.map(value => value)
      )
    def tablesLoaded: Optional[Integer]
    def elapsedTimeMillis: Optional[Long]
    def tablesLoading: Optional[Integer]
    def fullLoadPercentage: Optional[Integer]
    def cdcLatency: Optional[Integer]
    def tablesQueued: Optional[Integer]
    def tablesErrored: Optional[Integer]
    def startTime: Optional[Iso8601DateTime]
    def stopTime: Optional[Iso8601DateTime]
    def getTablesLoaded: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("tablesLoaded", tablesLoaded)
    def getElapsedTimeMillis: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("elapsedTimeMillis", elapsedTimeMillis)
    def getTablesLoading: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("tablesLoading", tablesLoading)
    def getFullLoadPercentage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("fullLoadPercentage", fullLoadPercentage)
    def getCdcLatency: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("cdcLatency", cdcLatency)
    def getTablesQueued: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("tablesQueued", tablesQueued)
    def getTablesErrored: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("tablesErrored", tablesErrored)
    def getStartTime: ZIO[Any, AwsError, Iso8601DateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getStopTime: ZIO[Any, AwsError, Iso8601DateTime] =
      AwsError.unwrapOptionField("stopTime", stopTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DataMigrationStatistics
  ) extends zio.aws.databasemigration.model.DataMigrationStatistics.ReadOnly {
    override val tablesLoaded: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.tablesLoaded())
      .map(value => value: Integer)
    override val elapsedTimeMillis: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.elapsedTimeMillis())
      .map(value => value: Long)
    override val tablesLoading: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.tablesLoading())
      .map(value => value: Integer)
    override val fullLoadPercentage: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.fullLoadPercentage())
      .map(value => value: Integer)
    override val cdcLatency: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.cdcLatency())
      .map(value => value: Integer)
    override val tablesQueued: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.tablesQueued())
      .map(value => value: Integer)
    override val tablesErrored: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.tablesErrored())
      .map(value => value: Integer)
    override val startTime: Optional[Iso8601DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value =>
        zio.aws.databasemigration.model.primitives.Iso8601DateTime(value)
      )
    override val stopTime: Optional[Iso8601DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.stopTime())
      .map(value =>
        zio.aws.databasemigration.model.primitives.Iso8601DateTime(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DataMigrationStatistics
  ): zio.aws.databasemigration.model.DataMigrationStatistics.ReadOnly =
    new Wrapper(impl)
}
