package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.{
  SecretString,
  BooleanOptional,
  IntegerOptional
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DataMigrationSettings(
    numberOfJobs: Optional[IntegerOptional] = Optional.Absent,
    cloudwatchLogsEnabled: Optional[BooleanOptional] = Optional.Absent,
    selectionRules: Optional[SecretString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DataMigrationSettings = {
    import DataMigrationSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DataMigrationSettings
      .builder()
      .optionallyWith(numberOfJobs.map(value => value: Integer))(_.numberOfJobs)
      .optionallyWith(
        cloudwatchLogsEnabled.map(value => value: java.lang.Boolean)
      )(_.cloudwatchLogsEnabled)
      .optionallyWith(
        selectionRules.map(value =>
          SecretString.unwrap(value): java.lang.String
        )
      )(_.selectionRules)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DataMigrationSettings.ReadOnly =
    zio.aws.databasemigration.model.DataMigrationSettings.wrap(buildAwsValue())
}
object DataMigrationSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DataMigrationSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.DataMigrationSettings =
      zio.aws.databasemigration.model.DataMigrationSettings(
        numberOfJobs.map(value => value),
        cloudwatchLogsEnabled.map(value => value),
        selectionRules.map(value => value)
      )
    def numberOfJobs: Optional[IntegerOptional]
    def cloudwatchLogsEnabled: Optional[BooleanOptional]
    def selectionRules: Optional[SecretString]
    def getNumberOfJobs: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numberOfJobs", numberOfJobs)
    def getCloudwatchLogsEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("cloudwatchLogsEnabled", cloudwatchLogsEnabled)
    def getSelectionRules: ZIO[Any, AwsError, SecretString] =
      AwsError.unwrapOptionField("selectionRules", selectionRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DataMigrationSettings
  ) extends zio.aws.databasemigration.model.DataMigrationSettings.ReadOnly {
    override val numberOfJobs: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.numberOfJobs())
      .map(value => value: IntegerOptional)
    override val cloudwatchLogsEnabled: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudwatchLogsEnabled())
        .map(value => value: BooleanOptional)
    override val selectionRules: Optional[SecretString] = zio.aws.core.internal
      .optionalFromNullable(impl.selectionRules())
      .map(value =>
        zio.aws.databasemigration.model.primitives.SecretString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DataMigrationSettings
  ): zio.aws.databasemigration.model.DataMigrationSettings.ReadOnly =
    new Wrapper(impl)
}
