package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.Iso8601DateTime
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DataMigration(
    dataMigrationName: Optional[String] = Optional.Absent,
    dataMigrationArn: Optional[String] = Optional.Absent,
    dataMigrationCreateTime: Optional[Iso8601DateTime] = Optional.Absent,
    dataMigrationStartTime: Optional[Iso8601DateTime] = Optional.Absent,
    dataMigrationEndTime: Optional[Iso8601DateTime] = Optional.Absent,
    serviceAccessRoleArn: Optional[String] = Optional.Absent,
    migrationProjectArn: Optional[String] = Optional.Absent,
    dataMigrationType: Optional[
      zio.aws.databasemigration.model.MigrationTypeValue
    ] = Optional.Absent,
    dataMigrationSettings: Optional[
      zio.aws.databasemigration.model.DataMigrationSettings
    ] = Optional.Absent,
    sourceDataSettings: Optional[
      Iterable[zio.aws.databasemigration.model.SourceDataSetting]
    ] = Optional.Absent,
    dataMigrationStatistics: Optional[
      zio.aws.databasemigration.model.DataMigrationStatistics
    ] = Optional.Absent,
    dataMigrationStatus: Optional[String] = Optional.Absent,
    publicIpAddresses: Optional[Iterable[String]] = Optional.Absent,
    lastFailureMessage: Optional[String] = Optional.Absent,
    stopReason: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DataMigration = {
    import DataMigration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DataMigration
      .builder()
      .optionallyWith(dataMigrationName.map(value => value: java.lang.String))(
        _.dataMigrationName
      )
      .optionallyWith(dataMigrationArn.map(value => value: java.lang.String))(
        _.dataMigrationArn
      )
      .optionallyWith(
        dataMigrationCreateTime.map(value =>
          Iso8601DateTime.unwrap(value): Instant
        )
      )(_.dataMigrationCreateTime)
      .optionallyWith(
        dataMigrationStartTime.map(value =>
          Iso8601DateTime.unwrap(value): Instant
        )
      )(_.dataMigrationStartTime)
      .optionallyWith(
        dataMigrationEndTime.map(value =>
          Iso8601DateTime.unwrap(value): Instant
        )
      )(_.dataMigrationEndTime)
      .optionallyWith(
        serviceAccessRoleArn.map(value => value: java.lang.String)
      )(_.serviceAccessRoleArn)
      .optionallyWith(
        migrationProjectArn.map(value => value: java.lang.String)
      )(_.migrationProjectArn)
      .optionallyWith(dataMigrationType.map(value => value.unwrap))(
        _.dataMigrationType
      )
      .optionallyWith(
        dataMigrationSettings.map(value => value.buildAwsValue())
      )(_.dataMigrationSettings)
      .optionallyWith(
        sourceDataSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sourceDataSettings)
      .optionallyWith(
        dataMigrationStatistics.map(value => value.buildAwsValue())
      )(_.dataMigrationStatistics)
      .optionallyWith(
        dataMigrationStatus.map(value => value: java.lang.String)
      )(_.dataMigrationStatus)
      .optionallyWith(
        publicIpAddresses.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.publicIpAddresses)
      .optionallyWith(lastFailureMessage.map(value => value: java.lang.String))(
        _.lastFailureMessage
      )
      .optionallyWith(stopReason.map(value => value: java.lang.String))(
        _.stopReason
      )
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.DataMigration.ReadOnly =
    zio.aws.databasemigration.model.DataMigration.wrap(buildAwsValue())
}
object DataMigration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DataMigration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.DataMigration =
      zio.aws.databasemigration.model.DataMigration(
        dataMigrationName.map(value => value),
        dataMigrationArn.map(value => value),
        dataMigrationCreateTime.map(value => value),
        dataMigrationStartTime.map(value => value),
        dataMigrationEndTime.map(value => value),
        serviceAccessRoleArn.map(value => value),
        migrationProjectArn.map(value => value),
        dataMigrationType.map(value => value),
        dataMigrationSettings.map(value => value.asEditable),
        sourceDataSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dataMigrationStatistics.map(value => value.asEditable),
        dataMigrationStatus.map(value => value),
        publicIpAddresses.map(value => value),
        lastFailureMessage.map(value => value),
        stopReason.map(value => value)
      )
    def dataMigrationName: Optional[String]
    def dataMigrationArn: Optional[String]
    def dataMigrationCreateTime: Optional[Iso8601DateTime]
    def dataMigrationStartTime: Optional[Iso8601DateTime]
    def dataMigrationEndTime: Optional[Iso8601DateTime]
    def serviceAccessRoleArn: Optional[String]
    def migrationProjectArn: Optional[String]
    def dataMigrationType
        : Optional[zio.aws.databasemigration.model.MigrationTypeValue]
    def dataMigrationSettings: Optional[
      zio.aws.databasemigration.model.DataMigrationSettings.ReadOnly
    ]
    def sourceDataSettings: Optional[
      List[zio.aws.databasemigration.model.SourceDataSetting.ReadOnly]
    ]
    def dataMigrationStatistics: Optional[
      zio.aws.databasemigration.model.DataMigrationStatistics.ReadOnly
    ]
    def dataMigrationStatus: Optional[String]
    def publicIpAddresses: Optional[List[String]]
    def lastFailureMessage: Optional[String]
    def stopReason: Optional[String]
    def getDataMigrationName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataMigrationName", dataMigrationName)
    def getDataMigrationArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataMigrationArn", dataMigrationArn)
    def getDataMigrationCreateTime: ZIO[Any, AwsError, Iso8601DateTime] =
      AwsError.unwrapOptionField(
        "dataMigrationCreateTime",
        dataMigrationCreateTime
      )
    def getDataMigrationStartTime: ZIO[Any, AwsError, Iso8601DateTime] =
      AwsError.unwrapOptionField(
        "dataMigrationStartTime",
        dataMigrationStartTime
      )
    def getDataMigrationEndTime: ZIO[Any, AwsError, Iso8601DateTime] =
      AwsError.unwrapOptionField("dataMigrationEndTime", dataMigrationEndTime)
    def getServiceAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceAccessRoleArn", serviceAccessRoleArn)
    def getMigrationProjectArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("migrationProjectArn", migrationProjectArn)
    def getDataMigrationType: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.MigrationTypeValue
    ] = AwsError.unwrapOptionField("dataMigrationType", dataMigrationType)
    def getDataMigrationSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.DataMigrationSettings.ReadOnly
    ] =
      AwsError.unwrapOptionField("dataMigrationSettings", dataMigrationSettings)
    def getSourceDataSettings: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.SourceDataSetting.ReadOnly
    ]] = AwsError.unwrapOptionField("sourceDataSettings", sourceDataSettings)
    def getDataMigrationStatistics: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.DataMigrationStatistics.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dataMigrationStatistics",
      dataMigrationStatistics
    )
    def getDataMigrationStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataMigrationStatus", dataMigrationStatus)
    def getPublicIpAddresses: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("publicIpAddresses", publicIpAddresses)
    def getLastFailureMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastFailureMessage", lastFailureMessage)
    def getStopReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stopReason", stopReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DataMigration
  ) extends zio.aws.databasemigration.model.DataMigration.ReadOnly {
    override val dataMigrationName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dataMigrationName())
      .map(value => value: String)
    override val dataMigrationArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dataMigrationArn())
      .map(value => value: String)
    override val dataMigrationCreateTime: Optional[Iso8601DateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataMigrationCreateTime())
        .map(value =>
          zio.aws.databasemigration.model.primitives.Iso8601DateTime(value)
        )
    override val dataMigrationStartTime: Optional[Iso8601DateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataMigrationStartTime())
        .map(value =>
          zio.aws.databasemigration.model.primitives.Iso8601DateTime(value)
        )
    override val dataMigrationEndTime: Optional[Iso8601DateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataMigrationEndTime())
        .map(value =>
          zio.aws.databasemigration.model.primitives.Iso8601DateTime(value)
        )
    override val serviceAccessRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceAccessRoleArn())
      .map(value => value: String)
    override val migrationProjectArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.migrationProjectArn())
      .map(value => value: String)
    override val dataMigrationType
        : Optional[zio.aws.databasemigration.model.MigrationTypeValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataMigrationType())
        .map(value =>
          zio.aws.databasemigration.model.MigrationTypeValue.wrap(value)
        )
    override val dataMigrationSettings: Optional[
      zio.aws.databasemigration.model.DataMigrationSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataMigrationSettings())
      .map(value =>
        zio.aws.databasemigration.model.DataMigrationSettings.wrap(value)
      )
    override val sourceDataSettings: Optional[
      List[zio.aws.databasemigration.model.SourceDataSetting.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceDataSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.SourceDataSetting.wrap(item)
        }.toList
      )
    override val dataMigrationStatistics: Optional[
      zio.aws.databasemigration.model.DataMigrationStatistics.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataMigrationStatistics())
      .map(value =>
        zio.aws.databasemigration.model.DataMigrationStatistics.wrap(value)
      )
    override val dataMigrationStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dataMigrationStatus())
      .map(value => value: String)
    override val publicIpAddresses: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publicIpAddresses())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val lastFailureMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastFailureMessage())
      .map(value => value: String)
    override val stopReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stopReason())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DataMigration
  ): zio.aws.databasemigration.model.DataMigration.ReadOnly = new Wrapper(impl)
}
