package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateDataMigrationResponse(
    dataMigration: Optional[zio.aws.databasemigration.model.DataMigration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.CreateDataMigrationResponse = {
    import CreateDataMigrationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.CreateDataMigrationResponse
      .builder()
      .optionallyWith(dataMigration.map(value => value.buildAwsValue()))(
        _.dataMigration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.CreateDataMigrationResponse.ReadOnly =
    zio.aws.databasemigration.model.CreateDataMigrationResponse
      .wrap(buildAwsValue())
}
object CreateDataMigrationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.CreateDataMigrationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.CreateDataMigrationResponse =
      zio.aws.databasemigration.model.CreateDataMigrationResponse(
        dataMigration.map(value => value.asEditable)
      )
    def dataMigration
        : Optional[zio.aws.databasemigration.model.DataMigration.ReadOnly]
    def getDataMigration: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.DataMigration.ReadOnly
    ] = AwsError.unwrapOptionField("dataMigration", dataMigration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateDataMigrationResponse
  ) extends zio.aws.databasemigration.model.CreateDataMigrationResponse.ReadOnly {
    override val dataMigration
        : Optional[zio.aws.databasemigration.model.DataMigration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataMigration())
        .map(value => zio.aws.databasemigration.model.DataMigration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateDataMigrationResponse
  ): zio.aws.databasemigration.model.CreateDataMigrationResponse.ReadOnly =
    new Wrapper(impl)
}
