package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.{
  SecretString,
  IntegerOptional,
  BooleanOptional
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateDataMigrationRequest(
    dataMigrationName: Optional[String] = Optional.Absent,
    migrationProjectIdentifier: String,
    dataMigrationType: zio.aws.databasemigration.model.MigrationTypeValue,
    serviceAccessRoleArn: String,
    enableCloudwatchLogs: Optional[BooleanOptional] = Optional.Absent,
    sourceDataSettings: Optional[
      Iterable[zio.aws.databasemigration.model.SourceDataSetting]
    ] = Optional.Absent,
    numberOfJobs: Optional[IntegerOptional] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.databasemigration.model.Tag]] =
      Optional.Absent,
    selectionRules: Optional[SecretString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.CreateDataMigrationRequest = {
    import CreateDataMigrationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.CreateDataMigrationRequest
      .builder()
      .optionallyWith(dataMigrationName.map(value => value: java.lang.String))(
        _.dataMigrationName
      )
      .migrationProjectIdentifier(migrationProjectIdentifier: java.lang.String)
      .dataMigrationType(dataMigrationType.unwrap)
      .serviceAccessRoleArn(serviceAccessRoleArn: java.lang.String)
      .optionallyWith(
        enableCloudwatchLogs.map(value => value: java.lang.Boolean)
      )(_.enableCloudwatchLogs)
      .optionallyWith(
        sourceDataSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sourceDataSettings)
      .optionallyWith(numberOfJobs.map(value => value: Integer))(_.numberOfJobs)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        selectionRules.map(value =>
          SecretString.unwrap(value): java.lang.String
        )
      )(_.selectionRules)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.CreateDataMigrationRequest.ReadOnly =
    zio.aws.databasemigration.model.CreateDataMigrationRequest
      .wrap(buildAwsValue())
}
object CreateDataMigrationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.CreateDataMigrationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.CreateDataMigrationRequest =
      zio.aws.databasemigration.model.CreateDataMigrationRequest(
        dataMigrationName.map(value => value),
        migrationProjectIdentifier,
        dataMigrationType,
        serviceAccessRoleArn,
        enableCloudwatchLogs.map(value => value),
        sourceDataSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        numberOfJobs.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        selectionRules.map(value => value)
      )
    def dataMigrationName: Optional[String]
    def migrationProjectIdentifier: String
    def dataMigrationType: zio.aws.databasemigration.model.MigrationTypeValue
    def serviceAccessRoleArn: String
    def enableCloudwatchLogs: Optional[BooleanOptional]
    def sourceDataSettings: Optional[
      List[zio.aws.databasemigration.model.SourceDataSetting.ReadOnly]
    ]
    def numberOfJobs: Optional[IntegerOptional]
    def tags: Optional[List[zio.aws.databasemigration.model.Tag.ReadOnly]]
    def selectionRules: Optional[SecretString]
    def getDataMigrationName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataMigrationName", dataMigrationName)
    def getMigrationProjectIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(migrationProjectIdentifier)
    def getDataMigrationType: ZIO[
      Any,
      Nothing,
      zio.aws.databasemigration.model.MigrationTypeValue
    ] = ZIO.succeed(dataMigrationType)
    def getServiceAccessRoleArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(serviceAccessRoleArn)
    def getEnableCloudwatchLogs: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("enableCloudwatchLogs", enableCloudwatchLogs)
    def getSourceDataSettings: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.SourceDataSetting.ReadOnly
    ]] = AwsError.unwrapOptionField("sourceDataSettings", sourceDataSettings)
    def getNumberOfJobs: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numberOfJobs", numberOfJobs)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getSelectionRules: ZIO[Any, AwsError, SecretString] =
      AwsError.unwrapOptionField("selectionRules", selectionRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateDataMigrationRequest
  ) extends zio.aws.databasemigration.model.CreateDataMigrationRequest.ReadOnly {
    override val dataMigrationName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dataMigrationName())
      .map(value => value: String)
    override val migrationProjectIdentifier: String =
      impl.migrationProjectIdentifier(): String
    override val dataMigrationType
        : zio.aws.databasemigration.model.MigrationTypeValue =
      zio.aws.databasemigration.model.MigrationTypeValue
        .wrap(impl.dataMigrationType())
    override val serviceAccessRoleArn: String =
      impl.serviceAccessRoleArn(): String
    override val enableCloudwatchLogs: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableCloudwatchLogs())
        .map(value => value: BooleanOptional)
    override val sourceDataSettings: Optional[
      List[zio.aws.databasemigration.model.SourceDataSetting.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceDataSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.SourceDataSetting.wrap(item)
        }.toList
      )
    override val numberOfJobs: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.numberOfJobs())
      .map(value => value: IntegerOptional)
    override val tags
        : Optional[List[zio.aws.databasemigration.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databasemigration.model.Tag.wrap(item)
          }.toList
        )
    override val selectionRules: Optional[SecretString] = zio.aws.core.internal
      .optionalFromNullable(impl.selectionRules())
      .map(value =>
        zio.aws.databasemigration.model.primitives.SecretString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateDataMigrationRequest
  ): zio.aws.databasemigration.model.CreateDataMigrationRequest.ReadOnly =
    new Wrapper(impl)
}
