package zio.aws.databasemigration.model
import scala.jdk.CollectionConverters.*
sealed trait CollectorStatus {
  def unwrap
      : software.amazon.awssdk.services.databasemigration.model.CollectorStatus
}
object CollectorStatus {
  def wrap(
      value: software.amazon.awssdk.services.databasemigration.model.CollectorStatus
  ): zio.aws.databasemigration.model.CollectorStatus = value match {
    case software.amazon.awssdk.services.databasemigration.model.CollectorStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databasemigration.model.CollectorStatus.UNREGISTERED =>
      val r = UNREGISTERED
      r
    case software.amazon.awssdk.services.databasemigration.model.CollectorStatus.ACTIVE =>
      val r = ACTIVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.databasemigration.model.CollectorStatus {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.CollectorStatus =
      software.amazon.awssdk.services.databasemigration.model.CollectorStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object UNREGISTERED
      extends zio.aws.databasemigration.model.CollectorStatus {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.CollectorStatus =
      software.amazon.awssdk.services.databasemigration.model.CollectorStatus.UNREGISTERED
  }
  case object ACTIVE extends zio.aws.databasemigration.model.CollectorStatus {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.CollectorStatus =
      software.amazon.awssdk.services.databasemigration.model.CollectorStatus.ACTIVE
  }
}
