package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CollectorShortInfoResponse(
    collectorReferencedId: Optional[String] = Optional.Absent,
    collectorName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.CollectorShortInfoResponse = {
    import CollectorShortInfoResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.CollectorShortInfoResponse
      .builder()
      .optionallyWith(
        collectorReferencedId.map(value => value: java.lang.String)
      )(_.collectorReferencedId)
      .optionallyWith(collectorName.map(value => value: java.lang.String))(
        _.collectorName
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.CollectorShortInfoResponse.ReadOnly =
    zio.aws.databasemigration.model.CollectorShortInfoResponse
      .wrap(buildAwsValue())
}
object CollectorShortInfoResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.CollectorShortInfoResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.CollectorShortInfoResponse =
      zio.aws.databasemigration.model.CollectorShortInfoResponse(
        collectorReferencedId.map(value => value),
        collectorName.map(value => value)
      )
    def collectorReferencedId: Optional[String]
    def collectorName: Optional[String]
    def getCollectorReferencedId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("collectorReferencedId", collectorReferencedId)
    def getCollectorName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("collectorName", collectorName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.CollectorShortInfoResponse
  ) extends zio.aws.databasemigration.model.CollectorShortInfoResponse.ReadOnly {
    override val collectorReferencedId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.collectorReferencedId())
      .map(value => value: String)
    override val collectorName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.collectorName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.CollectorShortInfoResponse
  ): zio.aws.databasemigration.model.CollectorShortInfoResponse.ReadOnly =
    new Wrapper(impl)
}
