package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.{
  IntegerOptional,
  CertificateWallet,
  TStamp
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class Certificate(
    certificateIdentifier: Optional[String] = Optional.Absent,
    certificateCreationDate: Optional[TStamp] = Optional.Absent,
    certificatePem: Optional[String] = Optional.Absent,
    certificateWallet: Optional[CertificateWallet] = Optional.Absent,
    certificateArn: Optional[String] = Optional.Absent,
    certificateOwner: Optional[String] = Optional.Absent,
    validFromDate: Optional[TStamp] = Optional.Absent,
    validToDate: Optional[TStamp] = Optional.Absent,
    signingAlgorithm: Optional[String] = Optional.Absent,
    keyLength: Optional[IntegerOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.Certificate = {
    import Certificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.Certificate
      .builder()
      .optionallyWith(
        certificateIdentifier.map(value => value: java.lang.String)
      )(_.certificateIdentifier)
      .optionallyWith(
        certificateCreationDate.map(value => TStamp.unwrap(value): Instant)
      )(_.certificateCreationDate)
      .optionallyWith(certificatePem.map(value => value: java.lang.String))(
        _.certificatePem
      )
      .optionallyWith(
        certificateWallet.map(value =>
          software.amazon.awssdk.core.SdkBytes.fromByteArrayUnsafe(
            value.toArray[Byte]
          )
        )
      )(_.certificateWallet)
      .optionallyWith(certificateArn.map(value => value: java.lang.String))(
        _.certificateArn
      )
      .optionallyWith(certificateOwner.map(value => value: java.lang.String))(
        _.certificateOwner
      )
      .optionallyWith(
        validFromDate.map(value => TStamp.unwrap(value): Instant)
      )(_.validFromDate)
      .optionallyWith(validToDate.map(value => TStamp.unwrap(value): Instant))(
        _.validToDate
      )
      .optionallyWith(signingAlgorithm.map(value => value: java.lang.String))(
        _.signingAlgorithm
      )
      .optionallyWith(keyLength.map(value => value: Integer))(_.keyLength)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.Certificate.ReadOnly =
    zio.aws.databasemigration.model.Certificate.wrap(buildAwsValue())
}
object Certificate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.Certificate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.Certificate =
      zio.aws.databasemigration.model.Certificate(
        certificateIdentifier.map(value => value),
        certificateCreationDate.map(value => value),
        certificatePem.map(value => value),
        certificateWallet.map(value => value),
        certificateArn.map(value => value),
        certificateOwner.map(value => value),
        validFromDate.map(value => value),
        validToDate.map(value => value),
        signingAlgorithm.map(value => value),
        keyLength.map(value => value)
      )
    def certificateIdentifier: Optional[String]
    def certificateCreationDate: Optional[TStamp]
    def certificatePem: Optional[String]
    def certificateWallet: Optional[CertificateWallet]
    def certificateArn: Optional[String]
    def certificateOwner: Optional[String]
    def validFromDate: Optional[TStamp]
    def validToDate: Optional[TStamp]
    def signingAlgorithm: Optional[String]
    def keyLength: Optional[IntegerOptional]
    def getCertificateIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateIdentifier", certificateIdentifier)
    def getCertificateCreationDate: ZIO[Any, AwsError, TStamp] = AwsError
      .unwrapOptionField("certificateCreationDate", certificateCreationDate)
    def getCertificatePem: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificatePem", certificatePem)
    def getCertificateWallet: ZIO[Any, AwsError, CertificateWallet] =
      AwsError.unwrapOptionField("certificateWallet", certificateWallet)
    def getCertificateArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getCertificateOwner: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateOwner", certificateOwner)
    def getValidFromDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("validFromDate", validFromDate)
    def getValidToDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("validToDate", validToDate)
    def getSigningAlgorithm: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("signingAlgorithm", signingAlgorithm)
    def getKeyLength: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("keyLength", keyLength)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.Certificate
  ) extends zio.aws.databasemigration.model.Certificate.ReadOnly {
    override val certificateIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateIdentifier())
      .map(value => value: String)
    override val certificateCreationDate: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateCreationDate())
        .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val certificatePem: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.certificatePem())
      .map(value => value: String)
    override val certificateWallet: Optional[CertificateWallet] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateWallet())
        .map(value =>
          zio.aws.databasemigration.model.primitives
            .CertificateWallet(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
        )
    override val certificateArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateArn())
      .map(value => value: String)
    override val certificateOwner: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateOwner())
      .map(value => value: String)
    override val validFromDate: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.validFromDate())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val validToDate: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.validToDate())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val signingAlgorithm: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.signingAlgorithm())
      .map(value => value: String)
    override val keyLength: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.keyLength())
      .map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.Certificate
  ): zio.aws.databasemigration.model.Certificate.ReadOnly = new Wrapper(impl)
}
