package zio.aws.databasemigration.model
import scala.jdk.CollectionConverters.*
sealed trait AssessmentReportType {
  def unwrap: software.amazon.awssdk.services.databasemigration.model.AssessmentReportType
}
object AssessmentReportType {
  def wrap(
      value: software.amazon.awssdk.services.databasemigration.model.AssessmentReportType
  ): zio.aws.databasemigration.model.AssessmentReportType = value match {
    case software.amazon.awssdk.services.databasemigration.model.AssessmentReportType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databasemigration.model.AssessmentReportType.PDF =>
      val r = pdf
      r
    case software.amazon.awssdk.services.databasemigration.model.AssessmentReportType.CSV =>
      val r = csv
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.databasemigration.model.AssessmentReportType {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.AssessmentReportType =
      software.amazon.awssdk.services.databasemigration.model.AssessmentReportType.UNKNOWN_TO_SDK_VERSION
  }
  case object pdf extends zio.aws.databasemigration.model.AssessmentReportType {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.AssessmentReportType =
      software.amazon.awssdk.services.databasemigration.model.AssessmentReportType.PDF
  }
  case object csv extends zio.aws.databasemigration.model.AssessmentReportType {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.AssessmentReportType =
      software.amazon.awssdk.services.databasemigration.model.AssessmentReportType.CSV
  }
}
