package zio.aws.databasemigration
import zio.aws.databasemigration.model.StartMetadataModelExportAsScriptResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.databasemigration.model.{
  DescribeEventCategoriesRequest,
  CreateEndpointRequest,
  ReloadReplicationTablesResponse,
  DeleteDataProviderRequest,
  StartRecommendationsRequest,
  DescribeConversionConfigurationRequest,
  DescribeReplicationTaskAssessmentRunsRequest,
  CreateReplicationConfigRequest,
  DescribeRefreshSchemasStatusRequest,
  DescribeSchemasResponse,
  StopReplicationTaskRequest,
  StartMetadataModelAssessmentRequest,
  CreateDataProviderRequest,
  DescribeApplicableIndividualAssessmentsRequest,
  CreateMigrationProjectResponse,
  DescribeEventsResponse,
  StartExtensionPackAssociationResponse,
  DescribeDataMigrationsResponse,
  CreateMigrationProjectRequest,
  DescribeReplicationConfigsRequest,
  ModifyEventSubscriptionRequest,
  DescribeFleetAdvisorLsaAnalysisRequest,
  DescribeReplicationTaskAssessmentResultsRequest,
  StartReplicationResponse,
  ModifyMigrationProjectResponse,
  DeleteEndpointRequest,
  UpdateSubscriptionsToEventBridgeRequest,
  DeleteEndpointResponse,
  DescribeReplicationTableStatisticsRequest,
  ModifyReplicationTaskRequest,
  StartMetadataModelConversionResponse,
  DeleteConnectionResponse,
  DescribeSchemasRequest,
  DeleteReplicationTaskAssessmentRunResponse,
  StartMetadataModelExportAsScriptRequest,
  TestConnectionRequest,
  DeleteFleetAdvisorCollectorResponse,
  ExportMetadataModelAssessmentResponse,
  DescribeInstanceProfilesResponse,
  DescribeEndpointsRequest,
  CreateReplicationInstanceResponse,
  DescribeFleetAdvisorSchemaObjectSummaryResponse,
  DescribeMetadataModelConversionsRequest,
  ModifyReplicationInstanceRequest,
  CreateInstanceProfileRequest,
  DeleteReplicationConfigResponse,
  DescribeFleetAdvisorCollectorsResponse,
  CreateDataMigrationResponse,
  RunFleetAdvisorLsaAnalysisResponse,
  CreateEventSubscriptionRequest,
  AddTagsToResourceRequest,
  ModifyMigrationProjectRequest,
  DescribeFleetAdvisorDatabasesRequest,
  StartMetadataModelExportToTargetRequest,
  CollectorResponse,
  DatabaseResponse,
  StartReplicationTaskAssessmentRunRequest,
  DescribeEventCategoriesResponse,
  RemoveTagsFromResourceResponse,
  DeleteReplicationInstanceResponse,
  StartReplicationTaskResponse,
  UpdateSubscriptionsToEventBridgeResponse,
  ModifyEventSubscriptionResponse,
  ModifyDataMigrationRequest,
  DeleteReplicationTaskAssessmentRunRequest,
  DescribeExtensionPackAssociationsResponse,
  DescribeConnectionsRequest,
  CreateInstanceProfileResponse,
  CreateDataProviderResponse,
  DescribeEngineVersionsRequest,
  ModifyDataMigrationResponse,
  DescribeEventsRequest,
  DescribeFleetAdvisorSchemasRequest,
  CancelReplicationTaskAssessmentRunResponse,
  FleetAdvisorLsaAnalysisResponse,
  DescribePendingMaintenanceActionsResponse,
  ApplyPendingMaintenanceActionRequest,
  StartReplicationTaskRequest,
  ModifyReplicationInstanceResponse,
  DescribeReplicationTasksResponse,
  DeleteCertificateResponse,
  StartReplicationRequest,
  CreateDataMigrationRequest,
  DescribeReplicationTaskIndividualAssessmentsResponse,
  ListTagsForResourceRequest,
  DeleteEventSubscriptionRequest,
  DescribeFleetAdvisorCollectorsRequest,
  DescribeReplicationsRequest,
  DescribeOrderableReplicationInstancesResponse,
  DescribeReplicationInstanceTaskLogsRequest,
  DescribeReplicationsResponse,
  DescribeReplicationSubnetGroupsRequest,
  StopReplicationResponse,
  DeleteInstanceProfileRequest,
  DeleteFleetAdvisorDatabasesRequest,
  ImportCertificateResponse,
  StartMetadataModelImportResponse,
  StartMetadataModelConversionRequest,
  CreateReplicationTaskRequest,
  RefreshSchemasResponse,
  ModifyConversionConfigurationResponse,
  DeleteReplicationSubnetGroupRequest,
  ModifyConversionConfigurationRequest,
  DescribeConnectionsResponse,
  DescribeMigrationProjectsResponse,
  CreateReplicationSubnetGroupResponse,
  ModifyDataProviderRequest,
  DescribeDataMigrationsRequest,
  ApplyPendingMaintenanceActionResponse,
  DescribeMetadataModelExportsToTargetRequest,
  ListTagsForResourceResponse,
  DescribeCertificatesResponse,
  DescribeReplicationConfigsResponse,
  DeleteDataProviderResponse,
  DeleteConnectionRequest,
  SchemaResponse,
  DescribeEndpointTypesRequest,
  DescribeMetadataModelExportsAsScriptResponse,
  ReloadTablesRequest,
  CreateFleetAdvisorCollectorRequest,
  DescribeEventSubscriptionsResponse,
  DescribeEndpointsResponse,
  DescribeMetadataModelExportsToTargetResponse,
  StopReplicationTaskResponse,
  DescribeOrderableReplicationInstancesRequest,
  DescribeEndpointTypesResponse,
  DataMigration,
  CreateEventSubscriptionResponse,
  Limitation,
  ModifyEndpointResponse,
  DeleteMigrationProjectResponse,
  DescribeReplicationSubnetGroupsResponse,
  StartMetadataModelExportAsScriptResponse,
  RunFleetAdvisorLsaAnalysisRequest,
  RebootReplicationInstanceResponse,
  DescribeRecommendationsResponse,
  RemoveTagsFromResourceRequest,
  DeleteReplicationTaskResponse,
  DeleteReplicationTaskRequest,
  FleetAdvisorSchemaObjectResponse,
  DescribeFleetAdvisorSchemaObjectSummaryRequest,
  DescribeReplicationInstanceTaskLogsResponse,
  DeleteFleetAdvisorCollectorRequest,
  StartExtensionPackAssociationRequest,
  DescribeCertificatesRequest,
  DescribeRecommendationLimitationsResponse,
  Recommendation,
  BatchStartRecommendationsRequest,
  DeleteReplicationSubnetGroupResponse,
  DescribePendingMaintenanceActionsRequest,
  DescribeTableStatisticsRequest,
  CreateReplicationInstanceRequest,
  DescribeMetadataModelAssessmentsRequest,
  DeleteDataMigrationRequest,
  RebootReplicationInstanceRequest,
  CreateFleetAdvisorCollectorResponse,
  DescribeFleetAdvisorDatabasesResponse,
  CreateReplicationConfigResponse,
  DescribeEngineVersionsResponse,
  ModifyDataProviderResponse,
  ModifyReplicationSubnetGroupRequest,
  MoveReplicationTaskRequest,
  StartDataMigrationResponse,
  StartMetadataModelAssessmentResponse,
  DescribeMetadataModelAssessmentsResponse,
  CreateEndpointResponse,
  DescribeFleetAdvisorLsaAnalysisResponse,
  CreateReplicationTaskResponse,
  DescribeInstanceProfilesRequest,
  ExportMetadataModelAssessmentRequest,
  DescribeDataProvidersResponse,
  DescribeRecommendationLimitationsRequest,
  DescribeReplicationInstancesResponse,
  DescribeTableStatisticsResponse,
  DescribeReplicationTaskIndividualAssessmentsRequest,
  DeleteInstanceProfileResponse,
  DescribeAccountAttributesRequest,
  DescribeMetadataModelImportsRequest,
  DescribeReplicationTasksRequest,
  AddTagsToResourceResponse,
  StartDataMigrationRequest,
  DescribeDataProvidersRequest,
  StartRecommendationsResponse,
  MoveReplicationTaskResponse,
  StartReplicationTaskAssessmentResponse,
  StopReplicationRequest,
  DeleteMigrationProjectRequest,
  TestConnectionResponse,
  StartMetadataModelImportRequest,
  DeleteDataMigrationResponse,
  DescribeConversionConfigurationResponse,
  ImportCertificateRequest,
  DeleteReplicationConfigRequest,
  ModifyReplicationConfigResponse,
  StartReplicationTaskAssessmentRunResponse,
  ModifyInstanceProfileResponse,
  ModifyReplicationConfigRequest,
  BatchStartRecommendationsResponse,
  ModifyReplicationSubnetGroupResponse,
  DescribeMetadataModelExportsAsScriptRequest,
  DescribeApplicableIndividualAssessmentsResponse,
  DescribeRefreshSchemasStatusResponse,
  DescribeEndpointSettingsResponse,
  DescribeFleetAdvisorSchemasResponse,
  ModifyInstanceProfileRequest,
  DescribeReplicationInstancesRequest,
  ReloadTablesResponse,
  CreateReplicationSubnetGroupRequest,
  DescribeEndpointSettingsRequest,
  RefreshSchemasRequest,
  DeleteEventSubscriptionResponse,
  DeleteReplicationInstanceRequest,
  DescribeMetadataModelImportsResponse,
  StopDataMigrationResponse,
  DescribeAccountAttributesResponse,
  DescribeEventSubscriptionsRequest,
  DescribeMetadataModelConversionsResponse,
  ReloadReplicationTablesRequest,
  DescribeExtensionPackAssociationsRequest,
  CancelReplicationTaskAssessmentRunRequest,
  StopDataMigrationRequest,
  StartMetadataModelExportToTargetResponse,
  DescribeReplicationTaskAssessmentRunsResponse,
  ModifyReplicationTaskResponse,
  DescribeReplicationTableStatisticsResponse,
  DeleteFleetAdvisorDatabasesResponse,
  DeleteCertificateRequest,
  ModifyEndpointRequest,
  DescribeReplicationTaskAssessmentResultsResponse,
  DescribeMigrationProjectsRequest,
  DescribeRecommendationsRequest,
  StartReplicationTaskAssessmentRequest
}
import software.amazon.awssdk.services.databasemigration.{
  DatabaseMigrationAsyncClientBuilder,
  DatabaseMigrationAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.databasemigration.paginators.DescribeDataMigrationsPublisher
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait DatabaseMigration extends AspectSupport[DatabaseMigration] {
  val api: DatabaseMigrationAsyncClient
  def modifyInstanceProfile(
      request: zio.aws.databasemigration.model.ModifyInstanceProfileRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.ModifyInstanceProfileResponse.ReadOnly
  ]
  def describeFleetAdvisorCollectors(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorCollectorsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.databasemigration.model.CollectorResponse.ReadOnly
  ]
  def describeFleetAdvisorCollectorsPaginated(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorCollectorsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeFleetAdvisorCollectorsResponse.ReadOnly
  ]
  def stopReplication(
      request: zio.aws.databasemigration.model.StopReplicationRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.StopReplicationResponse.ReadOnly
  ]
  def modifyConversionConfiguration(
      request: zio.aws.databasemigration.model.ModifyConversionConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.ModifyConversionConfigurationResponse.ReadOnly
  ]
  def modifyDataMigration(
      request: zio.aws.databasemigration.model.ModifyDataMigrationRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.ModifyDataMigrationResponse.ReadOnly
  ]
  def startMetadataModelAssessment(
      request: zio.aws.databasemigration.model.StartMetadataModelAssessmentRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.StartMetadataModelAssessmentResponse.ReadOnly
  ]
  def addTagsToResource(
      request: zio.aws.databasemigration.model.AddTagsToResourceRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.AddTagsToResourceResponse.ReadOnly
  ]
  def describeOrderableReplicationInstances(
      request: zio.aws.databasemigration.model.DescribeOrderableReplicationInstancesRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeOrderableReplicationInstancesResponse.ReadOnly
  ]
  def deleteMigrationProject(
      request: zio.aws.databasemigration.model.DeleteMigrationProjectRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DeleteMigrationProjectResponse.ReadOnly
  ]
  def deleteDataProvider(
      request: zio.aws.databasemigration.model.DeleteDataProviderRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DeleteDataProviderResponse.ReadOnly
  ]
  def describeReplicationInstanceTaskLogs(
      request: zio.aws.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse.ReadOnly
  ]
  def describePendingMaintenanceActions(
      request: zio.aws.databasemigration.model.DescribePendingMaintenanceActionsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribePendingMaintenanceActionsResponse.ReadOnly
  ]
  def refreshSchemas(
      request: zio.aws.databasemigration.model.RefreshSchemasRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.RefreshSchemasResponse.ReadOnly
  ]
  def describeTableStatistics(
      request: zio.aws.databasemigration.model.DescribeTableStatisticsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeTableStatisticsResponse.ReadOnly
  ]
  def deleteReplicationSubnetGroup(
      request: zio.aws.databasemigration.model.DeleteReplicationSubnetGroupRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DeleteReplicationSubnetGroupResponse.ReadOnly
  ]
  def stopReplicationTask(
      request: zio.aws.databasemigration.model.StopReplicationTaskRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.StopReplicationTaskResponse.ReadOnly
  ]
  def startMetadataModelExportToTarget(
      request: zio.aws.databasemigration.model.StartMetadataModelExportToTargetRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.StartMetadataModelExportToTargetResponse.ReadOnly
  ]
  def cancelReplicationTaskAssessmentRun(
      request: zio.aws.databasemigration.model.CancelReplicationTaskAssessmentRunRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.CancelReplicationTaskAssessmentRunResponse.ReadOnly
  ]
  def describeMetadataModelExportsToTarget(
      request: zio.aws.databasemigration.model.DescribeMetadataModelExportsToTargetRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeMetadataModelExportsToTargetResponse.ReadOnly
  ]
  def describeRefreshSchemasStatus(
      request: zio.aws.databasemigration.model.DescribeRefreshSchemasStatusRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeRefreshSchemasStatusResponse.ReadOnly
  ]
  def startReplicationTask(
      request: zio.aws.databasemigration.model.StartReplicationTaskRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.StartReplicationTaskResponse.ReadOnly
  ]
  def describeCertificates(
      request: zio.aws.databasemigration.model.DescribeCertificatesRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeCertificatesResponse.ReadOnly
  ]
  def modifyReplicationTask(
      request: zio.aws.databasemigration.model.ModifyReplicationTaskRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.ModifyReplicationTaskResponse.ReadOnly
  ]
  def deleteEventSubscription(
      request: zio.aws.databasemigration.model.DeleteEventSubscriptionRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DeleteEventSubscriptionResponse.ReadOnly
  ]
  def moveReplicationTask(
      request: zio.aws.databasemigration.model.MoveReplicationTaskRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.MoveReplicationTaskResponse.ReadOnly
  ]
  def modifyMigrationProject(
      request: zio.aws.databasemigration.model.ModifyMigrationProjectRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.ModifyMigrationProjectResponse.ReadOnly
  ]
  def startReplicationTaskAssessment(
      request: zio.aws.databasemigration.model.StartReplicationTaskAssessmentRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.StartReplicationTaskAssessmentResponse.ReadOnly
  ]
  def describeReplicationSubnetGroups(
      request: zio.aws.databasemigration.model.DescribeReplicationSubnetGroupsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeReplicationSubnetGroupsResponse.ReadOnly
  ]
  def startReplication(
      request: zio.aws.databasemigration.model.StartReplicationRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.StartReplicationResponse.ReadOnly
  ]
  def describeFleetAdvisorSchemaObjectSummary(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.databasemigration.model.FleetAdvisorSchemaObjectResponse.ReadOnly
  ]
  def describeFleetAdvisorSchemaObjectSummaryPaginated(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryResponse.ReadOnly
  ]
  def removeTagsFromResource(
      request: zio.aws.databasemigration.model.RemoveTagsFromResourceRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.RemoveTagsFromResourceResponse.ReadOnly
  ]
  def createMigrationProject(
      request: zio.aws.databasemigration.model.CreateMigrationProjectRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.CreateMigrationProjectResponse.ReadOnly
  ]
  def describeReplicationTasks(
      request: zio.aws.databasemigration.model.DescribeReplicationTasksRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeReplicationTasksResponse.ReadOnly
  ]
  def createReplicationSubnetGroup(
      request: zio.aws.databasemigration.model.CreateReplicationSubnetGroupRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.CreateReplicationSubnetGroupResponse.ReadOnly
  ]
  def describeReplicationTaskIndividualAssessments(
      request: zio.aws.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse.ReadOnly
  ]
  def applyPendingMaintenanceAction(
      request: zio.aws.databasemigration.model.ApplyPendingMaintenanceActionRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.ApplyPendingMaintenanceActionResponse.ReadOnly
  ]
  def describeExtensionPackAssociations(
      request: zio.aws.databasemigration.model.DescribeExtensionPackAssociationsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeExtensionPackAssociationsResponse.ReadOnly
  ]
  def createDataProvider(
      request: zio.aws.databasemigration.model.CreateDataProviderRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.CreateDataProviderResponse.ReadOnly
  ]
  def describeReplicationTaskAssessmentResults(
      request: zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse.ReadOnly
  ]
  def describeReplicationTableStatistics(
      request: zio.aws.databasemigration.model.DescribeReplicationTableStatisticsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeReplicationTableStatisticsResponse.ReadOnly
  ]
  def deleteCertificate(
      request: zio.aws.databasemigration.model.DeleteCertificateRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DeleteCertificateResponse.ReadOnly
  ]
  def deleteEndpoint(
      request: zio.aws.databasemigration.model.DeleteEndpointRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DeleteEndpointResponse.ReadOnly
  ]
  def modifyReplicationSubnetGroup(
      request: zio.aws.databasemigration.model.ModifyReplicationSubnetGroupRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.ModifyReplicationSubnetGroupResponse.ReadOnly
  ]
  def describeRecommendationLimitations(
      request: zio.aws.databasemigration.model.DescribeRecommendationLimitationsRequest
  ): ZStream[Any, AwsError, zio.aws.databasemigration.model.Limitation.ReadOnly]
  def describeRecommendationLimitationsPaginated(
      request: zio.aws.databasemigration.model.DescribeRecommendationLimitationsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeRecommendationLimitationsResponse.ReadOnly
  ]
  def startExtensionPackAssociation(
      request: zio.aws.databasemigration.model.StartExtensionPackAssociationRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.StartExtensionPackAssociationResponse.ReadOnly
  ]
  def modifyReplicationInstance(
      request: zio.aws.databasemigration.model.ModifyReplicationInstanceRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.ModifyReplicationInstanceResponse.ReadOnly
  ]
  def startMetadataModelConversion(
      request: zio.aws.databasemigration.model.StartMetadataModelConversionRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.StartMetadataModelConversionResponse.ReadOnly
  ]
  def testConnection(
      request: zio.aws.databasemigration.model.TestConnectionRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.TestConnectionResponse.ReadOnly
  ]
  def describeMetadataModelExportsAsScript(
      request: zio.aws.databasemigration.model.DescribeMetadataModelExportsAsScriptRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeMetadataModelExportsAsScriptResponse.ReadOnly
  ]
  def deleteReplicationTaskAssessmentRun(
      request: zio.aws.databasemigration.model.DeleteReplicationTaskAssessmentRunRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DeleteReplicationTaskAssessmentRunResponse.ReadOnly
  ]
  def describeFleetAdvisorSchemas(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorSchemasRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.databasemigration.model.SchemaResponse.ReadOnly
  ]
  def describeFleetAdvisorSchemasPaginated(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorSchemasRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeFleetAdvisorSchemasResponse.ReadOnly
  ]
  def createReplicationTask(
      request: zio.aws.databasemigration.model.CreateReplicationTaskRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.CreateReplicationTaskResponse.ReadOnly
  ]
  def describeMetadataModelConversions(
      request: zio.aws.databasemigration.model.DescribeMetadataModelConversionsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeMetadataModelConversionsResponse.ReadOnly
  ]
  def describeFleetAdvisorDatabases(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorDatabasesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.databasemigration.model.DatabaseResponse.ReadOnly
  ]
  def describeFleetAdvisorDatabasesPaginated(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorDatabasesRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeFleetAdvisorDatabasesResponse.ReadOnly
  ]
  def describeRecommendations(
      request: zio.aws.databasemigration.model.DescribeRecommendationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.databasemigration.model.Recommendation.ReadOnly
  ]
  def describeRecommendationsPaginated(
      request: zio.aws.databasemigration.model.DescribeRecommendationsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeRecommendationsResponse.ReadOnly
  ]
  def modifyEventSubscription(
      request: zio.aws.databasemigration.model.ModifyEventSubscriptionRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.ModifyEventSubscriptionResponse.ReadOnly
  ]
  def updateSubscriptionsToEventBridge(
      request: zio.aws.databasemigration.model.UpdateSubscriptionsToEventBridgeRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.UpdateSubscriptionsToEventBridgeResponse.ReadOnly
  ]
  def modifyDataProvider(
      request: zio.aws.databasemigration.model.ModifyDataProviderRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.ModifyDataProviderResponse.ReadOnly
  ]
  def describeReplicationInstances(
      request: zio.aws.databasemigration.model.DescribeReplicationInstancesRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeReplicationInstancesResponse.ReadOnly
  ]
  def startMetadataModelExportAsScript(
      request: zio.aws.databasemigration.model.StartMetadataModelExportAsScriptRequest
  ): IO[AwsError, ReadOnly]
  def describeDataMigrations(
      request: zio.aws.databasemigration.model.DescribeDataMigrationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.databasemigration.model.DataMigration.ReadOnly
  ]
  def describeDataMigrationsPaginated(
      request: zio.aws.databasemigration.model.DescribeDataMigrationsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeDataMigrationsResponse.ReadOnly
  ]
  def describeEventCategories(
      request: zio.aws.databasemigration.model.DescribeEventCategoriesRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeEventCategoriesResponse.ReadOnly
  ]
  def createReplicationInstance(
      request: zio.aws.databasemigration.model.CreateReplicationInstanceRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.CreateReplicationInstanceResponse.ReadOnly
  ]
  def deleteReplicationInstance(
      request: zio.aws.databasemigration.model.DeleteReplicationInstanceRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DeleteReplicationInstanceResponse.ReadOnly
  ]
  def modifyReplicationConfig(
      request: zio.aws.databasemigration.model.ModifyReplicationConfigRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.ModifyReplicationConfigResponse.ReadOnly
  ]
  def describeReplicationConfigs(
      request: zio.aws.databasemigration.model.DescribeReplicationConfigsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeReplicationConfigsResponse.ReadOnly
  ]
  def describeEngineVersions(
      request: zio.aws.databasemigration.model.DescribeEngineVersionsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeEngineVersionsResponse.ReadOnly
  ]
  def createFleetAdvisorCollector(
      request: zio.aws.databasemigration.model.CreateFleetAdvisorCollectorRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.CreateFleetAdvisorCollectorResponse.ReadOnly
  ]
  def deleteInstanceProfile(
      request: zio.aws.databasemigration.model.DeleteInstanceProfileRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DeleteInstanceProfileResponse.ReadOnly
  ]
  def describeApplicableIndividualAssessments(
      request: zio.aws.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse.ReadOnly
  ]
  def describeReplicationTaskAssessmentRuns(
      request: zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse.ReadOnly
  ]
  def describeMetadataModelAssessments(
      request: zio.aws.databasemigration.model.DescribeMetadataModelAssessmentsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeMetadataModelAssessmentsResponse.ReadOnly
  ]
  def startDataMigration(
      request: zio.aws.databasemigration.model.StartDataMigrationRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.StartDataMigrationResponse.ReadOnly
  ]
  def reloadReplicationTables(
      request: zio.aws.databasemigration.model.ReloadReplicationTablesRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.ReloadReplicationTablesResponse.ReadOnly
  ]
  def describeEndpoints(
      request: zio.aws.databasemigration.model.DescribeEndpointsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeEndpointsResponse.ReadOnly
  ]
  def startReplicationTaskAssessmentRun(
      request: zio.aws.databasemigration.model.StartReplicationTaskAssessmentRunRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.StartReplicationTaskAssessmentRunResponse.ReadOnly
  ]
  def describeSchemas(
      request: zio.aws.databasemigration.model.DescribeSchemasRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeSchemasResponse.ReadOnly
  ]
  def createEventSubscription(
      request: zio.aws.databasemigration.model.CreateEventSubscriptionRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.CreateEventSubscriptionResponse.ReadOnly
  ]
  def describeConversionConfiguration(
      request: zio.aws.databasemigration.model.DescribeConversionConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeConversionConfigurationResponse.ReadOnly
  ]
  def describeEndpointSettings(
      request: zio.aws.databasemigration.model.DescribeEndpointSettingsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeEndpointSettingsResponse.ReadOnly
  ]
  def listTagsForResource(
      request: zio.aws.databasemigration.model.ListTagsForResourceRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.ListTagsForResourceResponse.ReadOnly
  ]
  def modifyEndpoint(
      request: zio.aws.databasemigration.model.ModifyEndpointRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.ModifyEndpointResponse.ReadOnly
  ]
  def startRecommendations(
      request: zio.aws.databasemigration.model.StartRecommendationsRequest
  ): IO[AwsError, Unit]
  def deleteFleetAdvisorCollector(
      request: zio.aws.databasemigration.model.DeleteFleetAdvisorCollectorRequest
  ): IO[AwsError, Unit]
  def deleteConnection(
      request: zio.aws.databasemigration.model.DeleteConnectionRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DeleteConnectionResponse.ReadOnly
  ]
  def deleteFleetAdvisorDatabases(
      request: zio.aws.databasemigration.model.DeleteFleetAdvisorDatabasesRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DeleteFleetAdvisorDatabasesResponse.ReadOnly
  ]
  def createEndpoint(
      request: zio.aws.databasemigration.model.CreateEndpointRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.CreateEndpointResponse.ReadOnly
  ]
  def createReplicationConfig(
      request: zio.aws.databasemigration.model.CreateReplicationConfigRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.CreateReplicationConfigResponse.ReadOnly
  ]
  def describeFleetAdvisorLsaAnalysis(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.databasemigration.model.FleetAdvisorLsaAnalysisResponse.ReadOnly
  ]
  def describeFleetAdvisorLsaAnalysisPaginated(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeFleetAdvisorLsaAnalysisResponse.ReadOnly
  ]
  def describeEventSubscriptions(
      request: zio.aws.databasemigration.model.DescribeEventSubscriptionsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeEventSubscriptionsResponse.ReadOnly
  ]
  def deleteDataMigration(
      request: zio.aws.databasemigration.model.DeleteDataMigrationRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DeleteDataMigrationResponse.ReadOnly
  ]
  def createDataMigration(
      request: zio.aws.databasemigration.model.CreateDataMigrationRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.CreateDataMigrationResponse.ReadOnly
  ]
  def describeEndpointTypes(
      request: zio.aws.databasemigration.model.DescribeEndpointTypesRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeEndpointTypesResponse.ReadOnly
  ]
  def describeConnections(
      request: zio.aws.databasemigration.model.DescribeConnectionsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeConnectionsResponse.ReadOnly
  ]
  def runFleetAdvisorLsaAnalysis(): IO[
    AwsError,
    zio.aws.databasemigration.model.RunFleetAdvisorLsaAnalysisResponse.ReadOnly
  ]
  def exportMetadataModelAssessment(
      request: zio.aws.databasemigration.model.ExportMetadataModelAssessmentRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.ExportMetadataModelAssessmentResponse.ReadOnly
  ]
  def describeMigrationProjects(
      request: zio.aws.databasemigration.model.DescribeMigrationProjectsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeMigrationProjectsResponse.ReadOnly
  ]
  def stopDataMigration(
      request: zio.aws.databasemigration.model.StopDataMigrationRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.StopDataMigrationResponse.ReadOnly
  ]
  def createInstanceProfile(
      request: zio.aws.databasemigration.model.CreateInstanceProfileRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.CreateInstanceProfileResponse.ReadOnly
  ]
  def describeMetadataModelImports(
      request: zio.aws.databasemigration.model.DescribeMetadataModelImportsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeMetadataModelImportsResponse.ReadOnly
  ]
  def describeReplications(
      request: zio.aws.databasemigration.model.DescribeReplicationsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeReplicationsResponse.ReadOnly
  ]
  def describeAccountAttributes(
      request: zio.aws.databasemigration.model.DescribeAccountAttributesRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeAccountAttributesResponse.ReadOnly
  ]
  def deleteReplicationConfig(
      request: zio.aws.databasemigration.model.DeleteReplicationConfigRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DeleteReplicationConfigResponse.ReadOnly
  ]
  def importCertificate(
      request: zio.aws.databasemigration.model.ImportCertificateRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.ImportCertificateResponse.ReadOnly
  ]
  def describeDataProviders(
      request: zio.aws.databasemigration.model.DescribeDataProvidersRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeDataProvidersResponse.ReadOnly
  ]
  def batchStartRecommendations(
      request: zio.aws.databasemigration.model.BatchStartRecommendationsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.BatchStartRecommendationsResponse.ReadOnly
  ]
  def reloadTables(
      request: zio.aws.databasemigration.model.ReloadTablesRequest
  ): IO[AwsError, zio.aws.databasemigration.model.ReloadTablesResponse.ReadOnly]
  def rebootReplicationInstance(
      request: zio.aws.databasemigration.model.RebootReplicationInstanceRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.RebootReplicationInstanceResponse.ReadOnly
  ]
  def deleteReplicationTask(
      request: zio.aws.databasemigration.model.DeleteReplicationTaskRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DeleteReplicationTaskResponse.ReadOnly
  ]
  def describeEvents(
      request: zio.aws.databasemigration.model.DescribeEventsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeEventsResponse.ReadOnly
  ]
  def startMetadataModelImport(
      request: zio.aws.databasemigration.model.StartMetadataModelImportRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.StartMetadataModelImportResponse.ReadOnly
  ]
  def describeInstanceProfiles(
      request: zio.aws.databasemigration.model.DescribeInstanceProfilesRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeInstanceProfilesResponse.ReadOnly
  ]
}
object DatabaseMigration {
  val live: ZLayer[AwsConfig, java.lang.Throwable, DatabaseMigration] =
    customized(identity)
  def customized(
      customization: DatabaseMigrationAsyncClientBuilder => DatabaseMigrationAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, DatabaseMigration] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: DatabaseMigrationAsyncClientBuilder => DatabaseMigrationAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, DatabaseMigration] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = DatabaseMigrationAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[
      DatabaseMigrationAsyncClient,
      DatabaseMigrationAsyncClientBuilder
    ](builder);
    b1 <- awsConfig.configureHttpClient[
      DatabaseMigrationAsyncClient,
      DatabaseMigrationAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new DatabaseMigrationImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class DatabaseMigrationImpl[R](
      override val api: DatabaseMigrationAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends DatabaseMigration
      with AwsServiceBase[R] {
    override val serviceName: String = "DatabaseMigration"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): DatabaseMigrationImpl[R1] = new DatabaseMigrationImpl(api, newAspect, r)
    def modifyInstanceProfile(
        request: zio.aws.databasemigration.model.ModifyInstanceProfileRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.ModifyInstanceProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyInstanceProfileRequest,
      ModifyInstanceProfileResponse
    ]("modifyInstanceProfile", api.modifyInstanceProfile)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.ModifyInstanceProfileResponse.wrap)
      .provideEnvironment(r)
    def describeFleetAdvisorCollectors(
        request: zio.aws.databasemigration.model.DescribeFleetAdvisorCollectorsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.databasemigration.model.CollectorResponse.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeFleetAdvisorCollectorsRequest,
      DescribeFleetAdvisorCollectorsResponse,
      CollectorResponse
    ](
      "describeFleetAdvisorCollectors",
      api.describeFleetAdvisorCollectors,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.collectors().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.databasemigration.model.CollectorResponse.wrap(item))
      .provideEnvironment(r)
    def describeFleetAdvisorCollectorsPaginated(
        request: zio.aws.databasemigration.model.DescribeFleetAdvisorCollectorsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeFleetAdvisorCollectorsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeFleetAdvisorCollectorsRequest,
      DescribeFleetAdvisorCollectorsResponse
    ]("describeFleetAdvisorCollectors", api.describeFleetAdvisorCollectors)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.DescribeFleetAdvisorCollectorsResponse.wrap
    ).provideEnvironment(r)
    def stopReplication(
        request: zio.aws.databasemigration.model.StopReplicationRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.StopReplicationResponse.ReadOnly
    ] = asyncRequestResponse[StopReplicationRequest, StopReplicationResponse](
      "stopReplication",
      api.stopReplication
    )(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.StopReplicationResponse.wrap)
      .provideEnvironment(r)
    def modifyConversionConfiguration(
        request: zio.aws.databasemigration.model.ModifyConversionConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.ModifyConversionConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyConversionConfigurationRequest,
      ModifyConversionConfigurationResponse
    ]("modifyConversionConfiguration", api.modifyConversionConfiguration)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.ModifyConversionConfigurationResponse.wrap
    ).provideEnvironment(r)
    def modifyDataMigration(
        request: zio.aws.databasemigration.model.ModifyDataMigrationRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.ModifyDataMigrationResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyDataMigrationRequest,
      ModifyDataMigrationResponse
    ]("modifyDataMigration", api.modifyDataMigration)(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.ModifyDataMigrationResponse.wrap)
      .provideEnvironment(r)
    def startMetadataModelAssessment(
        request: zio.aws.databasemigration.model.StartMetadataModelAssessmentRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.StartMetadataModelAssessmentResponse.ReadOnly
    ] = asyncRequestResponse[
      StartMetadataModelAssessmentRequest,
      StartMetadataModelAssessmentResponse
    ]("startMetadataModelAssessment", api.startMetadataModelAssessment)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.StartMetadataModelAssessmentResponse.wrap
    ).provideEnvironment(r)
    def addTagsToResource(
        request: zio.aws.databasemigration.model.AddTagsToResourceRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.AddTagsToResourceResponse.ReadOnly
    ] =
      asyncRequestResponse[AddTagsToResourceRequest, AddTagsToResourceResponse](
        "addTagsToResource",
        api.addTagsToResource
      )(request.buildAwsValue())
        .map(zio.aws.databasemigration.model.AddTagsToResourceResponse.wrap)
        .provideEnvironment(r)
    def describeOrderableReplicationInstances(
        request: zio.aws.databasemigration.model.DescribeOrderableReplicationInstancesRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeOrderableReplicationInstancesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeOrderableReplicationInstancesRequest,
      DescribeOrderableReplicationInstancesResponse
    ](
      "describeOrderableReplicationInstances",
      api.describeOrderableReplicationInstances
    )(request.buildAwsValue())
      .map(
        zio.aws.databasemigration.model.DescribeOrderableReplicationInstancesResponse.wrap
      )
      .provideEnvironment(r)
    def deleteMigrationProject(
        request: zio.aws.databasemigration.model.DeleteMigrationProjectRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DeleteMigrationProjectResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteMigrationProjectRequest,
      DeleteMigrationProjectResponse
    ]("deleteMigrationProject", api.deleteMigrationProject)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.DeleteMigrationProjectResponse.wrap)
      .provideEnvironment(r)
    def deleteDataProvider(
        request: zio.aws.databasemigration.model.DeleteDataProviderRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DeleteDataProviderResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteDataProviderRequest,
      DeleteDataProviderResponse
    ]("deleteDataProvider", api.deleteDataProvider)(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.DeleteDataProviderResponse.wrap)
      .provideEnvironment(r)
    def describeReplicationInstanceTaskLogs(
        request: zio.aws.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeReplicationInstanceTaskLogsRequest,
      DescribeReplicationInstanceTaskLogsResponse
    ](
      "describeReplicationInstanceTaskLogs",
      api.describeReplicationInstanceTaskLogs
    )(request.buildAwsValue())
      .map(
        zio.aws.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse.wrap
      )
      .provideEnvironment(r)
    def describePendingMaintenanceActions(
        request: zio.aws.databasemigration.model.DescribePendingMaintenanceActionsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribePendingMaintenanceActionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribePendingMaintenanceActionsRequest,
      DescribePendingMaintenanceActionsResponse
    ]("describePendingMaintenanceActions", api.describePendingMaintenanceActions)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.DescribePendingMaintenanceActionsResponse.wrap
    ).provideEnvironment(r)
    def refreshSchemas(
        request: zio.aws.databasemigration.model.RefreshSchemasRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.RefreshSchemasResponse.ReadOnly
    ] = asyncRequestResponse[RefreshSchemasRequest, RefreshSchemasResponse](
      "refreshSchemas",
      api.refreshSchemas
    )(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.RefreshSchemasResponse.wrap)
      .provideEnvironment(r)
    def describeTableStatistics(
        request: zio.aws.databasemigration.model.DescribeTableStatisticsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeTableStatisticsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeTableStatisticsRequest,
      DescribeTableStatisticsResponse
    ]("describeTableStatistics", api.describeTableStatistics)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.DescribeTableStatisticsResponse.wrap)
      .provideEnvironment(r)
    def deleteReplicationSubnetGroup(
        request: zio.aws.databasemigration.model.DeleteReplicationSubnetGroupRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DeleteReplicationSubnetGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteReplicationSubnetGroupRequest,
      DeleteReplicationSubnetGroupResponse
    ]("deleteReplicationSubnetGroup", api.deleteReplicationSubnetGroup)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.DeleteReplicationSubnetGroupResponse.wrap
    ).provideEnvironment(r)
    def stopReplicationTask(
        request: zio.aws.databasemigration.model.StopReplicationTaskRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.StopReplicationTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      StopReplicationTaskRequest,
      StopReplicationTaskResponse
    ]("stopReplicationTask", api.stopReplicationTask)(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.StopReplicationTaskResponse.wrap)
      .provideEnvironment(r)
    def startMetadataModelExportToTarget(
        request: zio.aws.databasemigration.model.StartMetadataModelExportToTargetRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.StartMetadataModelExportToTargetResponse.ReadOnly
    ] = asyncRequestResponse[
      StartMetadataModelExportToTargetRequest,
      StartMetadataModelExportToTargetResponse
    ]("startMetadataModelExportToTarget", api.startMetadataModelExportToTarget)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.StartMetadataModelExportToTargetResponse.wrap
    ).provideEnvironment(r)
    def cancelReplicationTaskAssessmentRun(
        request: zio.aws.databasemigration.model.CancelReplicationTaskAssessmentRunRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.CancelReplicationTaskAssessmentRunResponse.ReadOnly
    ] = asyncRequestResponse[
      CancelReplicationTaskAssessmentRunRequest,
      CancelReplicationTaskAssessmentRunResponse
    ](
      "cancelReplicationTaskAssessmentRun",
      api.cancelReplicationTaskAssessmentRun
    )(request.buildAwsValue())
      .map(
        zio.aws.databasemigration.model.CancelReplicationTaskAssessmentRunResponse.wrap
      )
      .provideEnvironment(r)
    def describeMetadataModelExportsToTarget(
        request: zio.aws.databasemigration.model.DescribeMetadataModelExportsToTargetRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeMetadataModelExportsToTargetResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeMetadataModelExportsToTargetRequest,
      DescribeMetadataModelExportsToTargetResponse
    ](
      "describeMetadataModelExportsToTarget",
      api.describeMetadataModelExportsToTarget
    )(request.buildAwsValue())
      .map(
        zio.aws.databasemigration.model.DescribeMetadataModelExportsToTargetResponse.wrap
      )
      .provideEnvironment(r)
    def describeRefreshSchemasStatus(
        request: zio.aws.databasemigration.model.DescribeRefreshSchemasStatusRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeRefreshSchemasStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeRefreshSchemasStatusRequest,
      DescribeRefreshSchemasStatusResponse
    ]("describeRefreshSchemasStatus", api.describeRefreshSchemasStatus)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.DescribeRefreshSchemasStatusResponse.wrap
    ).provideEnvironment(r)
    def startReplicationTask(
        request: zio.aws.databasemigration.model.StartReplicationTaskRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.StartReplicationTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      StartReplicationTaskRequest,
      StartReplicationTaskResponse
    ]("startReplicationTask", api.startReplicationTask)(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.StartReplicationTaskResponse.wrap)
      .provideEnvironment(r)
    def describeCertificates(
        request: zio.aws.databasemigration.model.DescribeCertificatesRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeCertificatesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeCertificatesRequest,
      DescribeCertificatesResponse
    ]("describeCertificates", api.describeCertificates)(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.DescribeCertificatesResponse.wrap)
      .provideEnvironment(r)
    def modifyReplicationTask(
        request: zio.aws.databasemigration.model.ModifyReplicationTaskRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.ModifyReplicationTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyReplicationTaskRequest,
      ModifyReplicationTaskResponse
    ]("modifyReplicationTask", api.modifyReplicationTask)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.ModifyReplicationTaskResponse.wrap)
      .provideEnvironment(r)
    def deleteEventSubscription(
        request: zio.aws.databasemigration.model.DeleteEventSubscriptionRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DeleteEventSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteEventSubscriptionRequest,
      DeleteEventSubscriptionResponse
    ]("deleteEventSubscription", api.deleteEventSubscription)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.DeleteEventSubscriptionResponse.wrap)
      .provideEnvironment(r)
    def moveReplicationTask(
        request: zio.aws.databasemigration.model.MoveReplicationTaskRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.MoveReplicationTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      MoveReplicationTaskRequest,
      MoveReplicationTaskResponse
    ]("moveReplicationTask", api.moveReplicationTask)(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.MoveReplicationTaskResponse.wrap)
      .provideEnvironment(r)
    def modifyMigrationProject(
        request: zio.aws.databasemigration.model.ModifyMigrationProjectRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.ModifyMigrationProjectResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyMigrationProjectRequest,
      ModifyMigrationProjectResponse
    ]("modifyMigrationProject", api.modifyMigrationProject)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.ModifyMigrationProjectResponse.wrap)
      .provideEnvironment(r)
    def startReplicationTaskAssessment(
        request: zio.aws.databasemigration.model.StartReplicationTaskAssessmentRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.StartReplicationTaskAssessmentResponse.ReadOnly
    ] = asyncRequestResponse[
      StartReplicationTaskAssessmentRequest,
      StartReplicationTaskAssessmentResponse
    ]("startReplicationTaskAssessment", api.startReplicationTaskAssessment)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.StartReplicationTaskAssessmentResponse.wrap
    ).provideEnvironment(r)
    def describeReplicationSubnetGroups(
        request: zio.aws.databasemigration.model.DescribeReplicationSubnetGroupsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeReplicationSubnetGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeReplicationSubnetGroupsRequest,
      DescribeReplicationSubnetGroupsResponse
    ]("describeReplicationSubnetGroups", api.describeReplicationSubnetGroups)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.DescribeReplicationSubnetGroupsResponse.wrap
    ).provideEnvironment(r)
    def startReplication(
        request: zio.aws.databasemigration.model.StartReplicationRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.StartReplicationResponse.ReadOnly
    ] = asyncRequestResponse[StartReplicationRequest, StartReplicationResponse](
      "startReplication",
      api.startReplication
    )(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.StartReplicationResponse.wrap)
      .provideEnvironment(r)
    def describeFleetAdvisorSchemaObjectSummary(
        request: zio.aws.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.databasemigration.model.FleetAdvisorSchemaObjectResponse.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeFleetAdvisorSchemaObjectSummaryRequest,
      DescribeFleetAdvisorSchemaObjectSummaryResponse,
      FleetAdvisorSchemaObjectResponse
    ](
      "describeFleetAdvisorSchemaObjectSummary",
      api.describeFleetAdvisorSchemaObjectSummary,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.fleetAdvisorSchemaObjects().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.databasemigration.model.FleetAdvisorSchemaObjectResponse
          .wrap(item)
      )
      .provideEnvironment(r)
    def describeFleetAdvisorSchemaObjectSummaryPaginated(
        request: zio.aws.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeFleetAdvisorSchemaObjectSummaryRequest,
      DescribeFleetAdvisorSchemaObjectSummaryResponse
    ](
      "describeFleetAdvisorSchemaObjectSummary",
      api.describeFleetAdvisorSchemaObjectSummary
    )(request.buildAwsValue())
      .map(
        zio.aws.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryResponse.wrap
      )
      .provideEnvironment(r)
    def removeTagsFromResource(
        request: zio.aws.databasemigration.model.RemoveTagsFromResourceRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.RemoveTagsFromResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      RemoveTagsFromResourceRequest,
      RemoveTagsFromResourceResponse
    ]("removeTagsFromResource", api.removeTagsFromResource)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.RemoveTagsFromResourceResponse.wrap)
      .provideEnvironment(r)
    def createMigrationProject(
        request: zio.aws.databasemigration.model.CreateMigrationProjectRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.CreateMigrationProjectResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateMigrationProjectRequest,
      CreateMigrationProjectResponse
    ]("createMigrationProject", api.createMigrationProject)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.CreateMigrationProjectResponse.wrap)
      .provideEnvironment(r)
    def describeReplicationTasks(
        request: zio.aws.databasemigration.model.DescribeReplicationTasksRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeReplicationTasksResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeReplicationTasksRequest,
      DescribeReplicationTasksResponse
    ]("describeReplicationTasks", api.describeReplicationTasks)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.DescribeReplicationTasksResponse.wrap)
      .provideEnvironment(r)
    def createReplicationSubnetGroup(
        request: zio.aws.databasemigration.model.CreateReplicationSubnetGroupRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.CreateReplicationSubnetGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateReplicationSubnetGroupRequest,
      CreateReplicationSubnetGroupResponse
    ]("createReplicationSubnetGroup", api.createReplicationSubnetGroup)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.CreateReplicationSubnetGroupResponse.wrap
    ).provideEnvironment(r)
    def describeReplicationTaskIndividualAssessments(
        request: zio.aws.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeReplicationTaskIndividualAssessmentsRequest,
      DescribeReplicationTaskIndividualAssessmentsResponse
    ](
      "describeReplicationTaskIndividualAssessments",
      api.describeReplicationTaskIndividualAssessments
    )(request.buildAwsValue())
      .map(
        zio.aws.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse.wrap
      )
      .provideEnvironment(r)
    def applyPendingMaintenanceAction(
        request: zio.aws.databasemigration.model.ApplyPendingMaintenanceActionRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.ApplyPendingMaintenanceActionResponse.ReadOnly
    ] = asyncRequestResponse[
      ApplyPendingMaintenanceActionRequest,
      ApplyPendingMaintenanceActionResponse
    ]("applyPendingMaintenanceAction", api.applyPendingMaintenanceAction)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.ApplyPendingMaintenanceActionResponse.wrap
    ).provideEnvironment(r)
    def describeExtensionPackAssociations(
        request: zio.aws.databasemigration.model.DescribeExtensionPackAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeExtensionPackAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeExtensionPackAssociationsRequest,
      DescribeExtensionPackAssociationsResponse
    ]("describeExtensionPackAssociations", api.describeExtensionPackAssociations)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.DescribeExtensionPackAssociationsResponse.wrap
    ).provideEnvironment(r)
    def createDataProvider(
        request: zio.aws.databasemigration.model.CreateDataProviderRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.CreateDataProviderResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateDataProviderRequest,
      CreateDataProviderResponse
    ]("createDataProvider", api.createDataProvider)(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.CreateDataProviderResponse.wrap)
      .provideEnvironment(r)
    def describeReplicationTaskAssessmentResults(
        request: zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeReplicationTaskAssessmentResultsRequest,
      DescribeReplicationTaskAssessmentResultsResponse
    ](
      "describeReplicationTaskAssessmentResults",
      api.describeReplicationTaskAssessmentResults
    )(request.buildAwsValue())
      .map(
        zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse.wrap
      )
      .provideEnvironment(r)
    def describeReplicationTableStatistics(
        request: zio.aws.databasemigration.model.DescribeReplicationTableStatisticsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeReplicationTableStatisticsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeReplicationTableStatisticsRequest,
      DescribeReplicationTableStatisticsResponse
    ](
      "describeReplicationTableStatistics",
      api.describeReplicationTableStatistics
    )(request.buildAwsValue())
      .map(
        zio.aws.databasemigration.model.DescribeReplicationTableStatisticsResponse.wrap
      )
      .provideEnvironment(r)
    def deleteCertificate(
        request: zio.aws.databasemigration.model.DeleteCertificateRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DeleteCertificateResponse.ReadOnly
    ] =
      asyncRequestResponse[DeleteCertificateRequest, DeleteCertificateResponse](
        "deleteCertificate",
        api.deleteCertificate
      )(request.buildAwsValue())
        .map(zio.aws.databasemigration.model.DeleteCertificateResponse.wrap)
        .provideEnvironment(r)
    def deleteEndpoint(
        request: zio.aws.databasemigration.model.DeleteEndpointRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DeleteEndpointResponse.ReadOnly
    ] = asyncRequestResponse[DeleteEndpointRequest, DeleteEndpointResponse](
      "deleteEndpoint",
      api.deleteEndpoint
    )(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.DeleteEndpointResponse.wrap)
      .provideEnvironment(r)
    def modifyReplicationSubnetGroup(
        request: zio.aws.databasemigration.model.ModifyReplicationSubnetGroupRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.ModifyReplicationSubnetGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyReplicationSubnetGroupRequest,
      ModifyReplicationSubnetGroupResponse
    ]("modifyReplicationSubnetGroup", api.modifyReplicationSubnetGroup)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.ModifyReplicationSubnetGroupResponse.wrap
    ).provideEnvironment(r)
    def describeRecommendationLimitations(
        request: zio.aws.databasemigration.model.DescribeRecommendationLimitationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.databasemigration.model.Limitation.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeRecommendationLimitationsRequest,
      DescribeRecommendationLimitationsResponse,
      Limitation
    ](
      "describeRecommendationLimitations",
      api.describeRecommendationLimitations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.limitations().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.databasemigration.model.Limitation.wrap(item))
      .provideEnvironment(r)
    def describeRecommendationLimitationsPaginated(
        request: zio.aws.databasemigration.model.DescribeRecommendationLimitationsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeRecommendationLimitationsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeRecommendationLimitationsRequest,
      DescribeRecommendationLimitationsResponse
    ]("describeRecommendationLimitations", api.describeRecommendationLimitations)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.DescribeRecommendationLimitationsResponse.wrap
    ).provideEnvironment(r)
    def startExtensionPackAssociation(
        request: zio.aws.databasemigration.model.StartExtensionPackAssociationRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.StartExtensionPackAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      StartExtensionPackAssociationRequest,
      StartExtensionPackAssociationResponse
    ]("startExtensionPackAssociation", api.startExtensionPackAssociation)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.StartExtensionPackAssociationResponse.wrap
    ).provideEnvironment(r)
    def modifyReplicationInstance(
        request: zio.aws.databasemigration.model.ModifyReplicationInstanceRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.ModifyReplicationInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyReplicationInstanceRequest,
      ModifyReplicationInstanceResponse
    ]("modifyReplicationInstance", api.modifyReplicationInstance)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.ModifyReplicationInstanceResponse.wrap
    ).provideEnvironment(r)
    def startMetadataModelConversion(
        request: zio.aws.databasemigration.model.StartMetadataModelConversionRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.StartMetadataModelConversionResponse.ReadOnly
    ] = asyncRequestResponse[
      StartMetadataModelConversionRequest,
      StartMetadataModelConversionResponse
    ]("startMetadataModelConversion", api.startMetadataModelConversion)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.StartMetadataModelConversionResponse.wrap
    ).provideEnvironment(r)
    def testConnection(
        request: zio.aws.databasemigration.model.TestConnectionRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.TestConnectionResponse.ReadOnly
    ] = asyncRequestResponse[TestConnectionRequest, TestConnectionResponse](
      "testConnection",
      api.testConnection
    )(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.TestConnectionResponse.wrap)
      .provideEnvironment(r)
    def describeMetadataModelExportsAsScript(
        request: zio.aws.databasemigration.model.DescribeMetadataModelExportsAsScriptRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeMetadataModelExportsAsScriptResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeMetadataModelExportsAsScriptRequest,
      DescribeMetadataModelExportsAsScriptResponse
    ](
      "describeMetadataModelExportsAsScript",
      api.describeMetadataModelExportsAsScript
    )(request.buildAwsValue())
      .map(
        zio.aws.databasemigration.model.DescribeMetadataModelExportsAsScriptResponse.wrap
      )
      .provideEnvironment(r)
    def deleteReplicationTaskAssessmentRun(
        request: zio.aws.databasemigration.model.DeleteReplicationTaskAssessmentRunRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DeleteReplicationTaskAssessmentRunResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteReplicationTaskAssessmentRunRequest,
      DeleteReplicationTaskAssessmentRunResponse
    ](
      "deleteReplicationTaskAssessmentRun",
      api.deleteReplicationTaskAssessmentRun
    )(request.buildAwsValue())
      .map(
        zio.aws.databasemigration.model.DeleteReplicationTaskAssessmentRunResponse.wrap
      )
      .provideEnvironment(r)
    def describeFleetAdvisorSchemas(
        request: zio.aws.databasemigration.model.DescribeFleetAdvisorSchemasRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.databasemigration.model.SchemaResponse.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeFleetAdvisorSchemasRequest,
      DescribeFleetAdvisorSchemasResponse,
      SchemaResponse
    ](
      "describeFleetAdvisorSchemas",
      api.describeFleetAdvisorSchemas,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.fleetAdvisorSchemas().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.databasemigration.model.SchemaResponse.wrap(item))
      .provideEnvironment(r)
    def describeFleetAdvisorSchemasPaginated(
        request: zio.aws.databasemigration.model.DescribeFleetAdvisorSchemasRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeFleetAdvisorSchemasResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeFleetAdvisorSchemasRequest,
      DescribeFleetAdvisorSchemasResponse
    ]("describeFleetAdvisorSchemas", api.describeFleetAdvisorSchemas)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.DescribeFleetAdvisorSchemasResponse.wrap
    ).provideEnvironment(r)
    def createReplicationTask(
        request: zio.aws.databasemigration.model.CreateReplicationTaskRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.CreateReplicationTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateReplicationTaskRequest,
      CreateReplicationTaskResponse
    ]("createReplicationTask", api.createReplicationTask)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.CreateReplicationTaskResponse.wrap)
      .provideEnvironment(r)
    def describeMetadataModelConversions(
        request: zio.aws.databasemigration.model.DescribeMetadataModelConversionsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeMetadataModelConversionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeMetadataModelConversionsRequest,
      DescribeMetadataModelConversionsResponse
    ]("describeMetadataModelConversions", api.describeMetadataModelConversions)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.DescribeMetadataModelConversionsResponse.wrap
    ).provideEnvironment(r)
    def describeFleetAdvisorDatabases(
        request: zio.aws.databasemigration.model.DescribeFleetAdvisorDatabasesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.databasemigration.model.DatabaseResponse.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeFleetAdvisorDatabasesRequest,
      DescribeFleetAdvisorDatabasesResponse,
      DatabaseResponse
    ](
      "describeFleetAdvisorDatabases",
      api.describeFleetAdvisorDatabases,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.databases().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.databasemigration.model.DatabaseResponse.wrap(item))
      .provideEnvironment(r)
    def describeFleetAdvisorDatabasesPaginated(
        request: zio.aws.databasemigration.model.DescribeFleetAdvisorDatabasesRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeFleetAdvisorDatabasesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeFleetAdvisorDatabasesRequest,
      DescribeFleetAdvisorDatabasesResponse
    ]("describeFleetAdvisorDatabases", api.describeFleetAdvisorDatabases)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.DescribeFleetAdvisorDatabasesResponse.wrap
    ).provideEnvironment(r)
    def describeRecommendations(
        request: zio.aws.databasemigration.model.DescribeRecommendationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.databasemigration.model.Recommendation.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeRecommendationsRequest,
      DescribeRecommendationsResponse,
      Recommendation
    ](
      "describeRecommendations",
      api.describeRecommendations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.recommendations().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.databasemigration.model.Recommendation.wrap(item))
      .provideEnvironment(r)
    def describeRecommendationsPaginated(
        request: zio.aws.databasemigration.model.DescribeRecommendationsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeRecommendationsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeRecommendationsRequest,
      DescribeRecommendationsResponse
    ]("describeRecommendations", api.describeRecommendations)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.DescribeRecommendationsResponse.wrap)
      .provideEnvironment(r)
    def modifyEventSubscription(
        request: zio.aws.databasemigration.model.ModifyEventSubscriptionRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.ModifyEventSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyEventSubscriptionRequest,
      ModifyEventSubscriptionResponse
    ]("modifyEventSubscription", api.modifyEventSubscription)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.ModifyEventSubscriptionResponse.wrap)
      .provideEnvironment(r)
    def updateSubscriptionsToEventBridge(
        request: zio.aws.databasemigration.model.UpdateSubscriptionsToEventBridgeRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.UpdateSubscriptionsToEventBridgeResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateSubscriptionsToEventBridgeRequest,
      UpdateSubscriptionsToEventBridgeResponse
    ]("updateSubscriptionsToEventBridge", api.updateSubscriptionsToEventBridge)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.UpdateSubscriptionsToEventBridgeResponse.wrap
    ).provideEnvironment(r)
    def modifyDataProvider(
        request: zio.aws.databasemigration.model.ModifyDataProviderRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.ModifyDataProviderResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyDataProviderRequest,
      ModifyDataProviderResponse
    ]("modifyDataProvider", api.modifyDataProvider)(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.ModifyDataProviderResponse.wrap)
      .provideEnvironment(r)
    def describeReplicationInstances(
        request: zio.aws.databasemigration.model.DescribeReplicationInstancesRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeReplicationInstancesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeReplicationInstancesRequest,
      DescribeReplicationInstancesResponse
    ]("describeReplicationInstances", api.describeReplicationInstances)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.DescribeReplicationInstancesResponse.wrap
    ).provideEnvironment(r)
    def startMetadataModelExportAsScript(
        request: zio.aws.databasemigration.model.StartMetadataModelExportAsScriptRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      StartMetadataModelExportAsScriptRequest,
      StartMetadataModelExportAsScriptResponse
    ]("startMetadataModelExportAsScript", api.startMetadataModelExportAsScript)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.StartMetadataModelExportAsScriptResponse.wrap
    ).provideEnvironment(r)
    def describeDataMigrations(
        request: zio.aws.databasemigration.model.DescribeDataMigrationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.databasemigration.model.DataMigration.ReadOnly
    ] = asyncJavaPaginatedRequest[
      DescribeDataMigrationsRequest,
      DataMigration,
      DescribeDataMigrationsPublisher
    ](
      "describeDataMigrations",
      api.describeDataMigrationsPaginator,
      _.dataMigrations()
    )(request.buildAwsValue())
      .map(item => zio.aws.databasemigration.model.DataMigration.wrap(item))
      .provideEnvironment(r)
    def describeDataMigrationsPaginated(
        request: zio.aws.databasemigration.model.DescribeDataMigrationsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeDataMigrationsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeDataMigrationsRequest,
      DescribeDataMigrationsResponse
    ]("describeDataMigrations", api.describeDataMigrations)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.DescribeDataMigrationsResponse.wrap)
      .provideEnvironment(r)
    def describeEventCategories(
        request: zio.aws.databasemigration.model.DescribeEventCategoriesRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeEventCategoriesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeEventCategoriesRequest,
      DescribeEventCategoriesResponse
    ]("describeEventCategories", api.describeEventCategories)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.DescribeEventCategoriesResponse.wrap)
      .provideEnvironment(r)
    def createReplicationInstance(
        request: zio.aws.databasemigration.model.CreateReplicationInstanceRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.CreateReplicationInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateReplicationInstanceRequest,
      CreateReplicationInstanceResponse
    ]("createReplicationInstance", api.createReplicationInstance)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.CreateReplicationInstanceResponse.wrap
    ).provideEnvironment(r)
    def deleteReplicationInstance(
        request: zio.aws.databasemigration.model.DeleteReplicationInstanceRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DeleteReplicationInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteReplicationInstanceRequest,
      DeleteReplicationInstanceResponse
    ]("deleteReplicationInstance", api.deleteReplicationInstance)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.DeleteReplicationInstanceResponse.wrap
    ).provideEnvironment(r)
    def modifyReplicationConfig(
        request: zio.aws.databasemigration.model.ModifyReplicationConfigRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.ModifyReplicationConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyReplicationConfigRequest,
      ModifyReplicationConfigResponse
    ]("modifyReplicationConfig", api.modifyReplicationConfig)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.ModifyReplicationConfigResponse.wrap)
      .provideEnvironment(r)
    def describeReplicationConfigs(
        request: zio.aws.databasemigration.model.DescribeReplicationConfigsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeReplicationConfigsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeReplicationConfigsRequest,
      DescribeReplicationConfigsResponse
    ]("describeReplicationConfigs", api.describeReplicationConfigs)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.DescribeReplicationConfigsResponse.wrap
    ).provideEnvironment(r)
    def describeEngineVersions(
        request: zio.aws.databasemigration.model.DescribeEngineVersionsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeEngineVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeEngineVersionsRequest,
      DescribeEngineVersionsResponse
    ]("describeEngineVersions", api.describeEngineVersions)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.DescribeEngineVersionsResponse.wrap)
      .provideEnvironment(r)
    def createFleetAdvisorCollector(
        request: zio.aws.databasemigration.model.CreateFleetAdvisorCollectorRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.CreateFleetAdvisorCollectorResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateFleetAdvisorCollectorRequest,
      CreateFleetAdvisorCollectorResponse
    ]("createFleetAdvisorCollector", api.createFleetAdvisorCollector)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.CreateFleetAdvisorCollectorResponse.wrap
    ).provideEnvironment(r)
    def deleteInstanceProfile(
        request: zio.aws.databasemigration.model.DeleteInstanceProfileRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DeleteInstanceProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteInstanceProfileRequest,
      DeleteInstanceProfileResponse
    ]("deleteInstanceProfile", api.deleteInstanceProfile)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.DeleteInstanceProfileResponse.wrap)
      .provideEnvironment(r)
    def describeApplicableIndividualAssessments(
        request: zio.aws.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeApplicableIndividualAssessmentsRequest,
      DescribeApplicableIndividualAssessmentsResponse
    ](
      "describeApplicableIndividualAssessments",
      api.describeApplicableIndividualAssessments
    )(request.buildAwsValue())
      .map(
        zio.aws.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse.wrap
      )
      .provideEnvironment(r)
    def describeReplicationTaskAssessmentRuns(
        request: zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeReplicationTaskAssessmentRunsRequest,
      DescribeReplicationTaskAssessmentRunsResponse
    ](
      "describeReplicationTaskAssessmentRuns",
      api.describeReplicationTaskAssessmentRuns
    )(request.buildAwsValue())
      .map(
        zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse.wrap
      )
      .provideEnvironment(r)
    def describeMetadataModelAssessments(
        request: zio.aws.databasemigration.model.DescribeMetadataModelAssessmentsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeMetadataModelAssessmentsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeMetadataModelAssessmentsRequest,
      DescribeMetadataModelAssessmentsResponse
    ]("describeMetadataModelAssessments", api.describeMetadataModelAssessments)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.DescribeMetadataModelAssessmentsResponse.wrap
    ).provideEnvironment(r)
    def startDataMigration(
        request: zio.aws.databasemigration.model.StartDataMigrationRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.StartDataMigrationResponse.ReadOnly
    ] = asyncRequestResponse[
      StartDataMigrationRequest,
      StartDataMigrationResponse
    ]("startDataMigration", api.startDataMigration)(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.StartDataMigrationResponse.wrap)
      .provideEnvironment(r)
    def reloadReplicationTables(
        request: zio.aws.databasemigration.model.ReloadReplicationTablesRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.ReloadReplicationTablesResponse.ReadOnly
    ] = asyncRequestResponse[
      ReloadReplicationTablesRequest,
      ReloadReplicationTablesResponse
    ]("reloadReplicationTables", api.reloadReplicationTables)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.ReloadReplicationTablesResponse.wrap)
      .provideEnvironment(r)
    def describeEndpoints(
        request: zio.aws.databasemigration.model.DescribeEndpointsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeEndpointsResponse.ReadOnly
    ] =
      asyncRequestResponse[DescribeEndpointsRequest, DescribeEndpointsResponse](
        "describeEndpoints",
        api.describeEndpoints
      )(request.buildAwsValue())
        .map(zio.aws.databasemigration.model.DescribeEndpointsResponse.wrap)
        .provideEnvironment(r)
    def startReplicationTaskAssessmentRun(
        request: zio.aws.databasemigration.model.StartReplicationTaskAssessmentRunRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.StartReplicationTaskAssessmentRunResponse.ReadOnly
    ] = asyncRequestResponse[
      StartReplicationTaskAssessmentRunRequest,
      StartReplicationTaskAssessmentRunResponse
    ]("startReplicationTaskAssessmentRun", api.startReplicationTaskAssessmentRun)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.StartReplicationTaskAssessmentRunResponse.wrap
    ).provideEnvironment(r)
    def describeSchemas(
        request: zio.aws.databasemigration.model.DescribeSchemasRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeSchemasResponse.ReadOnly
    ] = asyncRequestResponse[DescribeSchemasRequest, DescribeSchemasResponse](
      "describeSchemas",
      api.describeSchemas
    )(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.DescribeSchemasResponse.wrap)
      .provideEnvironment(r)
    def createEventSubscription(
        request: zio.aws.databasemigration.model.CreateEventSubscriptionRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.CreateEventSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateEventSubscriptionRequest,
      CreateEventSubscriptionResponse
    ]("createEventSubscription", api.createEventSubscription)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.CreateEventSubscriptionResponse.wrap)
      .provideEnvironment(r)
    def describeConversionConfiguration(
        request: zio.aws.databasemigration.model.DescribeConversionConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeConversionConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeConversionConfigurationRequest,
      DescribeConversionConfigurationResponse
    ]("describeConversionConfiguration", api.describeConversionConfiguration)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.DescribeConversionConfigurationResponse.wrap
    ).provideEnvironment(r)
    def describeEndpointSettings(
        request: zio.aws.databasemigration.model.DescribeEndpointSettingsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeEndpointSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeEndpointSettingsRequest,
      DescribeEndpointSettingsResponse
    ]("describeEndpointSettings", api.describeEndpointSettings)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.DescribeEndpointSettingsResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.databasemigration.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def modifyEndpoint(
        request: zio.aws.databasemigration.model.ModifyEndpointRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.ModifyEndpointResponse.ReadOnly
    ] = asyncRequestResponse[ModifyEndpointRequest, ModifyEndpointResponse](
      "modifyEndpoint",
      api.modifyEndpoint
    )(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.ModifyEndpointResponse.wrap)
      .provideEnvironment(r)
    def startRecommendations(
        request: zio.aws.databasemigration.model.StartRecommendationsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      StartRecommendationsRequest,
      StartRecommendationsResponse
    ]("startRecommendations", api.startRecommendations)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteFleetAdvisorCollector(
        request: zio.aws.databasemigration.model.DeleteFleetAdvisorCollectorRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteFleetAdvisorCollectorRequest,
      DeleteFleetAdvisorCollectorResponse
    ]("deleteFleetAdvisorCollector", api.deleteFleetAdvisorCollector)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteConnection(
        request: zio.aws.databasemigration.model.DeleteConnectionRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DeleteConnectionResponse.ReadOnly
    ] = asyncRequestResponse[DeleteConnectionRequest, DeleteConnectionResponse](
      "deleteConnection",
      api.deleteConnection
    )(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.DeleteConnectionResponse.wrap)
      .provideEnvironment(r)
    def deleteFleetAdvisorDatabases(
        request: zio.aws.databasemigration.model.DeleteFleetAdvisorDatabasesRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DeleteFleetAdvisorDatabasesResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteFleetAdvisorDatabasesRequest,
      DeleteFleetAdvisorDatabasesResponse
    ]("deleteFleetAdvisorDatabases", api.deleteFleetAdvisorDatabases)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.DeleteFleetAdvisorDatabasesResponse.wrap
    ).provideEnvironment(r)
    def createEndpoint(
        request: zio.aws.databasemigration.model.CreateEndpointRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.CreateEndpointResponse.ReadOnly
    ] = asyncRequestResponse[CreateEndpointRequest, CreateEndpointResponse](
      "createEndpoint",
      api.createEndpoint
    )(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.CreateEndpointResponse.wrap)
      .provideEnvironment(r)
    def createReplicationConfig(
        request: zio.aws.databasemigration.model.CreateReplicationConfigRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.CreateReplicationConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateReplicationConfigRequest,
      CreateReplicationConfigResponse
    ]("createReplicationConfig", api.createReplicationConfig)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.CreateReplicationConfigResponse.wrap)
      .provideEnvironment(r)
    def describeFleetAdvisorLsaAnalysis(
        request: zio.aws.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.databasemigration.model.FleetAdvisorLsaAnalysisResponse.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeFleetAdvisorLsaAnalysisRequest,
      DescribeFleetAdvisorLsaAnalysisResponse,
      FleetAdvisorLsaAnalysisResponse
    ](
      "describeFleetAdvisorLsaAnalysis",
      api.describeFleetAdvisorLsaAnalysis,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.analysis().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.databasemigration.model.FleetAdvisorLsaAnalysisResponse
          .wrap(item)
      )
      .provideEnvironment(r)
    def describeFleetAdvisorLsaAnalysisPaginated(
        request: zio.aws.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeFleetAdvisorLsaAnalysisResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeFleetAdvisorLsaAnalysisRequest,
      DescribeFleetAdvisorLsaAnalysisResponse
    ]("describeFleetAdvisorLsaAnalysis", api.describeFleetAdvisorLsaAnalysis)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.DescribeFleetAdvisorLsaAnalysisResponse.wrap
    ).provideEnvironment(r)
    def describeEventSubscriptions(
        request: zio.aws.databasemigration.model.DescribeEventSubscriptionsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeEventSubscriptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeEventSubscriptionsRequest,
      DescribeEventSubscriptionsResponse
    ]("describeEventSubscriptions", api.describeEventSubscriptions)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.DescribeEventSubscriptionsResponse.wrap
    ).provideEnvironment(r)
    def deleteDataMigration(
        request: zio.aws.databasemigration.model.DeleteDataMigrationRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DeleteDataMigrationResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteDataMigrationRequest,
      DeleteDataMigrationResponse
    ]("deleteDataMigration", api.deleteDataMigration)(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.DeleteDataMigrationResponse.wrap)
      .provideEnvironment(r)
    def createDataMigration(
        request: zio.aws.databasemigration.model.CreateDataMigrationRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.CreateDataMigrationResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateDataMigrationRequest,
      CreateDataMigrationResponse
    ]("createDataMigration", api.createDataMigration)(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.CreateDataMigrationResponse.wrap)
      .provideEnvironment(r)
    def describeEndpointTypes(
        request: zio.aws.databasemigration.model.DescribeEndpointTypesRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeEndpointTypesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeEndpointTypesRequest,
      DescribeEndpointTypesResponse
    ]("describeEndpointTypes", api.describeEndpointTypes)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.DescribeEndpointTypesResponse.wrap)
      .provideEnvironment(r)
    def describeConnections(
        request: zio.aws.databasemigration.model.DescribeConnectionsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeConnectionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeConnectionsRequest,
      DescribeConnectionsResponse
    ]("describeConnections", api.describeConnections)(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.DescribeConnectionsResponse.wrap)
      .provideEnvironment(r)
    def runFleetAdvisorLsaAnalysis(): IO[
      AwsError,
      zio.aws.databasemigration.model.RunFleetAdvisorLsaAnalysisResponse.ReadOnly
    ] = asyncRequestResponse[
      RunFleetAdvisorLsaAnalysisRequest,
      RunFleetAdvisorLsaAnalysisResponse
    ]("runFleetAdvisorLsaAnalysis", api.runFleetAdvisorLsaAnalysis)(
      RunFleetAdvisorLsaAnalysisRequest.builder().build()
    ).map(
      zio.aws.databasemigration.model.RunFleetAdvisorLsaAnalysisResponse.wrap
    ).provideEnvironment(r)
    def exportMetadataModelAssessment(
        request: zio.aws.databasemigration.model.ExportMetadataModelAssessmentRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.ExportMetadataModelAssessmentResponse.ReadOnly
    ] = asyncRequestResponse[
      ExportMetadataModelAssessmentRequest,
      ExportMetadataModelAssessmentResponse
    ]("exportMetadataModelAssessment", api.exportMetadataModelAssessment)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.ExportMetadataModelAssessmentResponse.wrap
    ).provideEnvironment(r)
    def describeMigrationProjects(
        request: zio.aws.databasemigration.model.DescribeMigrationProjectsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeMigrationProjectsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeMigrationProjectsRequest,
      DescribeMigrationProjectsResponse
    ]("describeMigrationProjects", api.describeMigrationProjects)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.DescribeMigrationProjectsResponse.wrap
    ).provideEnvironment(r)
    def stopDataMigration(
        request: zio.aws.databasemigration.model.StopDataMigrationRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.StopDataMigrationResponse.ReadOnly
    ] =
      asyncRequestResponse[StopDataMigrationRequest, StopDataMigrationResponse](
        "stopDataMigration",
        api.stopDataMigration
      )(request.buildAwsValue())
        .map(zio.aws.databasemigration.model.StopDataMigrationResponse.wrap)
        .provideEnvironment(r)
    def createInstanceProfile(
        request: zio.aws.databasemigration.model.CreateInstanceProfileRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.CreateInstanceProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateInstanceProfileRequest,
      CreateInstanceProfileResponse
    ]("createInstanceProfile", api.createInstanceProfile)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.CreateInstanceProfileResponse.wrap)
      .provideEnvironment(r)
    def describeMetadataModelImports(
        request: zio.aws.databasemigration.model.DescribeMetadataModelImportsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeMetadataModelImportsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeMetadataModelImportsRequest,
      DescribeMetadataModelImportsResponse
    ]("describeMetadataModelImports", api.describeMetadataModelImports)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.DescribeMetadataModelImportsResponse.wrap
    ).provideEnvironment(r)
    def describeReplications(
        request: zio.aws.databasemigration.model.DescribeReplicationsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeReplicationsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeReplicationsRequest,
      DescribeReplicationsResponse
    ]("describeReplications", api.describeReplications)(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.DescribeReplicationsResponse.wrap)
      .provideEnvironment(r)
    def describeAccountAttributes(
        request: zio.aws.databasemigration.model.DescribeAccountAttributesRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeAccountAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeAccountAttributesRequest,
      DescribeAccountAttributesResponse
    ]("describeAccountAttributes", api.describeAccountAttributes)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.DescribeAccountAttributesResponse.wrap
    ).provideEnvironment(r)
    def deleteReplicationConfig(
        request: zio.aws.databasemigration.model.DeleteReplicationConfigRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DeleteReplicationConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteReplicationConfigRequest,
      DeleteReplicationConfigResponse
    ]("deleteReplicationConfig", api.deleteReplicationConfig)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.DeleteReplicationConfigResponse.wrap)
      .provideEnvironment(r)
    def importCertificate(
        request: zio.aws.databasemigration.model.ImportCertificateRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.ImportCertificateResponse.ReadOnly
    ] =
      asyncRequestResponse[ImportCertificateRequest, ImportCertificateResponse](
        "importCertificate",
        api.importCertificate
      )(request.buildAwsValue())
        .map(zio.aws.databasemigration.model.ImportCertificateResponse.wrap)
        .provideEnvironment(r)
    def describeDataProviders(
        request: zio.aws.databasemigration.model.DescribeDataProvidersRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeDataProvidersResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeDataProvidersRequest,
      DescribeDataProvidersResponse
    ]("describeDataProviders", api.describeDataProviders)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.DescribeDataProvidersResponse.wrap)
      .provideEnvironment(r)
    def batchStartRecommendations(
        request: zio.aws.databasemigration.model.BatchStartRecommendationsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.BatchStartRecommendationsResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchStartRecommendationsRequest,
      BatchStartRecommendationsResponse
    ]("batchStartRecommendations", api.batchStartRecommendations)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.BatchStartRecommendationsResponse.wrap
    ).provideEnvironment(r)
    def reloadTables(
        request: zio.aws.databasemigration.model.ReloadTablesRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.ReloadTablesResponse.ReadOnly
    ] = asyncRequestResponse[ReloadTablesRequest, ReloadTablesResponse](
      "reloadTables",
      api.reloadTables
    )(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.ReloadTablesResponse.wrap)
      .provideEnvironment(r)
    def rebootReplicationInstance(
        request: zio.aws.databasemigration.model.RebootReplicationInstanceRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.RebootReplicationInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      RebootReplicationInstanceRequest,
      RebootReplicationInstanceResponse
    ]("rebootReplicationInstance", api.rebootReplicationInstance)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.RebootReplicationInstanceResponse.wrap
    ).provideEnvironment(r)
    def deleteReplicationTask(
        request: zio.aws.databasemigration.model.DeleteReplicationTaskRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DeleteReplicationTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteReplicationTaskRequest,
      DeleteReplicationTaskResponse
    ]("deleteReplicationTask", api.deleteReplicationTask)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.DeleteReplicationTaskResponse.wrap)
      .provideEnvironment(r)
    def describeEvents(
        request: zio.aws.databasemigration.model.DescribeEventsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeEventsResponse.ReadOnly
    ] = asyncRequestResponse[DescribeEventsRequest, DescribeEventsResponse](
      "describeEvents",
      api.describeEvents
    )(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.DescribeEventsResponse.wrap)
      .provideEnvironment(r)
    def startMetadataModelImport(
        request: zio.aws.databasemigration.model.StartMetadataModelImportRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.StartMetadataModelImportResponse.ReadOnly
    ] = asyncRequestResponse[
      StartMetadataModelImportRequest,
      StartMetadataModelImportResponse
    ]("startMetadataModelImport", api.startMetadataModelImport)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.StartMetadataModelImportResponse.wrap)
      .provideEnvironment(r)
    def describeInstanceProfiles(
        request: zio.aws.databasemigration.model.DescribeInstanceProfilesRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeInstanceProfilesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeInstanceProfilesRequest,
      DescribeInstanceProfilesResponse
    ]("describeInstanceProfiles", api.describeInstanceProfiles)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.DescribeInstanceProfilesResponse.wrap)
      .provideEnvironment(r)
  }
  def modifyInstanceProfile(
      request: zio.aws.databasemigration.model.ModifyInstanceProfileRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.ModifyInstanceProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyInstanceProfile(request))
  def describeFleetAdvisorCollectors(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorCollectorsRequest
  ): ZStream[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.CollectorResponse.ReadOnly
  ] = ZStream.serviceWithStream(_.describeFleetAdvisorCollectors(request))
  def describeFleetAdvisorCollectorsPaginated(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorCollectorsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeFleetAdvisorCollectorsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFleetAdvisorCollectorsPaginated(request))
  def stopReplication(
      request: zio.aws.databasemigration.model.StopReplicationRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.StopReplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopReplication(request))
  def modifyConversionConfiguration(
      request: zio.aws.databasemigration.model.ModifyConversionConfigurationRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.ModifyConversionConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyConversionConfiguration(request))
  def modifyDataMigration(
      request: zio.aws.databasemigration.model.ModifyDataMigrationRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.ModifyDataMigrationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyDataMigration(request))
  def startMetadataModelAssessment(
      request: zio.aws.databasemigration.model.StartMetadataModelAssessmentRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.StartMetadataModelAssessmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startMetadataModelAssessment(request))
  def addTagsToResource(
      request: zio.aws.databasemigration.model.AddTagsToResourceRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.AddTagsToResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addTagsToResource(request))
  def describeOrderableReplicationInstances(
      request: zio.aws.databasemigration.model.DescribeOrderableReplicationInstancesRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeOrderableReplicationInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeOrderableReplicationInstances(request))
  def deleteMigrationProject(
      request: zio.aws.databasemigration.model.DeleteMigrationProjectRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DeleteMigrationProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteMigrationProject(request))
  def deleteDataProvider(
      request: zio.aws.databasemigration.model.DeleteDataProviderRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DeleteDataProviderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDataProvider(request))
  def describeReplicationInstanceTaskLogs(
      request: zio.aws.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeReplicationInstanceTaskLogs(request))
  def describePendingMaintenanceActions(
      request: zio.aws.databasemigration.model.DescribePendingMaintenanceActionsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribePendingMaintenanceActionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePendingMaintenanceActions(request))
  def refreshSchemas(
      request: zio.aws.databasemigration.model.RefreshSchemasRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.RefreshSchemasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.refreshSchemas(request))
  def describeTableStatistics(
      request: zio.aws.databasemigration.model.DescribeTableStatisticsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeTableStatisticsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTableStatistics(request))
  def deleteReplicationSubnetGroup(
      request: zio.aws.databasemigration.model.DeleteReplicationSubnetGroupRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DeleteReplicationSubnetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteReplicationSubnetGroup(request))
  def stopReplicationTask(
      request: zio.aws.databasemigration.model.StopReplicationTaskRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.StopReplicationTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopReplicationTask(request))
  def startMetadataModelExportToTarget(
      request: zio.aws.databasemigration.model.StartMetadataModelExportToTargetRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.StartMetadataModelExportToTargetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startMetadataModelExportToTarget(request))
  def cancelReplicationTaskAssessmentRun(
      request: zio.aws.databasemigration.model.CancelReplicationTaskAssessmentRunRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.CancelReplicationTaskAssessmentRunResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelReplicationTaskAssessmentRun(request))
  def describeMetadataModelExportsToTarget(
      request: zio.aws.databasemigration.model.DescribeMetadataModelExportsToTargetRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeMetadataModelExportsToTargetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeMetadataModelExportsToTarget(request))
  def describeRefreshSchemasStatus(
      request: zio.aws.databasemigration.model.DescribeRefreshSchemasStatusRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeRefreshSchemasStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRefreshSchemasStatus(request))
  def startReplicationTask(
      request: zio.aws.databasemigration.model.StartReplicationTaskRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.StartReplicationTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startReplicationTask(request))
  def describeCertificates(
      request: zio.aws.databasemigration.model.DescribeCertificatesRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeCertificatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCertificates(request))
  def modifyReplicationTask(
      request: zio.aws.databasemigration.model.ModifyReplicationTaskRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.ModifyReplicationTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyReplicationTask(request))
  def deleteEventSubscription(
      request: zio.aws.databasemigration.model.DeleteEventSubscriptionRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DeleteEventSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEventSubscription(request))
  def moveReplicationTask(
      request: zio.aws.databasemigration.model.MoveReplicationTaskRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.MoveReplicationTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.moveReplicationTask(request))
  def modifyMigrationProject(
      request: zio.aws.databasemigration.model.ModifyMigrationProjectRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.ModifyMigrationProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyMigrationProject(request))
  def startReplicationTaskAssessment(
      request: zio.aws.databasemigration.model.StartReplicationTaskAssessmentRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.StartReplicationTaskAssessmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startReplicationTaskAssessment(request))
  def describeReplicationSubnetGroups(
      request: zio.aws.databasemigration.model.DescribeReplicationSubnetGroupsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeReplicationSubnetGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeReplicationSubnetGroups(request))
  def startReplication(
      request: zio.aws.databasemigration.model.StartReplicationRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.StartReplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startReplication(request))
  def describeFleetAdvisorSchemaObjectSummary(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryRequest
  ): ZStream[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.FleetAdvisorSchemaObjectResponse.ReadOnly
  ] = ZStream.serviceWithStream(
    _.describeFleetAdvisorSchemaObjectSummary(request)
  )
  def describeFleetAdvisorSchemaObjectSummaryPaginated(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.describeFleetAdvisorSchemaObjectSummaryPaginated(request)
  )
  def removeTagsFromResource(
      request: zio.aws.databasemigration.model.RemoveTagsFromResourceRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.RemoveTagsFromResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.removeTagsFromResource(request))
  def createMigrationProject(
      request: zio.aws.databasemigration.model.CreateMigrationProjectRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.CreateMigrationProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMigrationProject(request))
  def describeReplicationTasks(
      request: zio.aws.databasemigration.model.DescribeReplicationTasksRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeReplicationTasksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeReplicationTasks(request))
  def createReplicationSubnetGroup(
      request: zio.aws.databasemigration.model.CreateReplicationSubnetGroupRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.CreateReplicationSubnetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createReplicationSubnetGroup(request))
  def describeReplicationTaskIndividualAssessments(
      request: zio.aws.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.describeReplicationTaskIndividualAssessments(request))
  def applyPendingMaintenanceAction(
      request: zio.aws.databasemigration.model.ApplyPendingMaintenanceActionRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.ApplyPendingMaintenanceActionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.applyPendingMaintenanceAction(request))
  def describeExtensionPackAssociations(
      request: zio.aws.databasemigration.model.DescribeExtensionPackAssociationsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeExtensionPackAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeExtensionPackAssociations(request))
  def createDataProvider(
      request: zio.aws.databasemigration.model.CreateDataProviderRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.CreateDataProviderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDataProvider(request))
  def describeReplicationTaskAssessmentResults(
      request: zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeReplicationTaskAssessmentResults(request))
  def describeReplicationTableStatistics(
      request: zio.aws.databasemigration.model.DescribeReplicationTableStatisticsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeReplicationTableStatisticsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeReplicationTableStatistics(request))
  def deleteCertificate(
      request: zio.aws.databasemigration.model.DeleteCertificateRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DeleteCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCertificate(request))
  def deleteEndpoint(
      request: zio.aws.databasemigration.model.DeleteEndpointRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DeleteEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEndpoint(request))
  def modifyReplicationSubnetGroup(
      request: zio.aws.databasemigration.model.ModifyReplicationSubnetGroupRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.ModifyReplicationSubnetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyReplicationSubnetGroup(request))
  def describeRecommendationLimitations(
      request: zio.aws.databasemigration.model.DescribeRecommendationLimitationsRequest
  ): ZStream[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.Limitation.ReadOnly
  ] = ZStream.serviceWithStream(_.describeRecommendationLimitations(request))
  def describeRecommendationLimitationsPaginated(
      request: zio.aws.databasemigration.model.DescribeRecommendationLimitationsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeRecommendationLimitationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRecommendationLimitationsPaginated(request))
  def startExtensionPackAssociation(
      request: zio.aws.databasemigration.model.StartExtensionPackAssociationRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.StartExtensionPackAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startExtensionPackAssociation(request))
  def modifyReplicationInstance(
      request: zio.aws.databasemigration.model.ModifyReplicationInstanceRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.ModifyReplicationInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyReplicationInstance(request))
  def startMetadataModelConversion(
      request: zio.aws.databasemigration.model.StartMetadataModelConversionRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.StartMetadataModelConversionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startMetadataModelConversion(request))
  def testConnection(
      request: zio.aws.databasemigration.model.TestConnectionRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.TestConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.testConnection(request))
  def describeMetadataModelExportsAsScript(
      request: zio.aws.databasemigration.model.DescribeMetadataModelExportsAsScriptRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeMetadataModelExportsAsScriptResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeMetadataModelExportsAsScript(request))
  def deleteReplicationTaskAssessmentRun(
      request: zio.aws.databasemigration.model.DeleteReplicationTaskAssessmentRunRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DeleteReplicationTaskAssessmentRunResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteReplicationTaskAssessmentRun(request))
  def describeFleetAdvisorSchemas(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorSchemasRequest
  ): ZStream[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.SchemaResponse.ReadOnly
  ] = ZStream.serviceWithStream(_.describeFleetAdvisorSchemas(request))
  def describeFleetAdvisorSchemasPaginated(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorSchemasRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeFleetAdvisorSchemasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFleetAdvisorSchemasPaginated(request))
  def createReplicationTask(
      request: zio.aws.databasemigration.model.CreateReplicationTaskRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.CreateReplicationTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createReplicationTask(request))
  def describeMetadataModelConversions(
      request: zio.aws.databasemigration.model.DescribeMetadataModelConversionsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeMetadataModelConversionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeMetadataModelConversions(request))
  def describeFleetAdvisorDatabases(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorDatabasesRequest
  ): ZStream[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DatabaseResponse.ReadOnly
  ] = ZStream.serviceWithStream(_.describeFleetAdvisorDatabases(request))
  def describeFleetAdvisorDatabasesPaginated(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorDatabasesRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeFleetAdvisorDatabasesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFleetAdvisorDatabasesPaginated(request))
  def describeRecommendations(
      request: zio.aws.databasemigration.model.DescribeRecommendationsRequest
  ): ZStream[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.Recommendation.ReadOnly
  ] = ZStream.serviceWithStream(_.describeRecommendations(request))
  def describeRecommendationsPaginated(
      request: zio.aws.databasemigration.model.DescribeRecommendationsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeRecommendationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRecommendationsPaginated(request))
  def modifyEventSubscription(
      request: zio.aws.databasemigration.model.ModifyEventSubscriptionRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.ModifyEventSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyEventSubscription(request))
  def updateSubscriptionsToEventBridge(
      request: zio.aws.databasemigration.model.UpdateSubscriptionsToEventBridgeRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.UpdateSubscriptionsToEventBridgeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSubscriptionsToEventBridge(request))
  def modifyDataProvider(
      request: zio.aws.databasemigration.model.ModifyDataProviderRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.ModifyDataProviderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyDataProvider(request))
  def describeReplicationInstances(
      request: zio.aws.databasemigration.model.DescribeReplicationInstancesRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeReplicationInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeReplicationInstances(request))
  def startMetadataModelExportAsScript(
      request: zio.aws.databasemigration.model.StartMetadataModelExportAsScriptRequest
  ): ZIO[zio.aws.databasemigration.DatabaseMigration, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.startMetadataModelExportAsScript(request))
  def describeDataMigrations(
      request: zio.aws.databasemigration.model.DescribeDataMigrationsRequest
  ): ZStream[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DataMigration.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDataMigrations(request))
  def describeDataMigrationsPaginated(
      request: zio.aws.databasemigration.model.DescribeDataMigrationsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeDataMigrationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDataMigrationsPaginated(request))
  def describeEventCategories(
      request: zio.aws.databasemigration.model.DescribeEventCategoriesRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeEventCategoriesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEventCategories(request))
  def createReplicationInstance(
      request: zio.aws.databasemigration.model.CreateReplicationInstanceRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.CreateReplicationInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createReplicationInstance(request))
  def deleteReplicationInstance(
      request: zio.aws.databasemigration.model.DeleteReplicationInstanceRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DeleteReplicationInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteReplicationInstance(request))
  def modifyReplicationConfig(
      request: zio.aws.databasemigration.model.ModifyReplicationConfigRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.ModifyReplicationConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyReplicationConfig(request))
  def describeReplicationConfigs(
      request: zio.aws.databasemigration.model.DescribeReplicationConfigsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeReplicationConfigsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeReplicationConfigs(request))
  def describeEngineVersions(
      request: zio.aws.databasemigration.model.DescribeEngineVersionsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeEngineVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEngineVersions(request))
  def createFleetAdvisorCollector(
      request: zio.aws.databasemigration.model.CreateFleetAdvisorCollectorRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.CreateFleetAdvisorCollectorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFleetAdvisorCollector(request))
  def deleteInstanceProfile(
      request: zio.aws.databasemigration.model.DeleteInstanceProfileRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DeleteInstanceProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteInstanceProfile(request))
  def describeApplicableIndividualAssessments(
      request: zio.aws.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeApplicableIndividualAssessments(request))
  def describeReplicationTaskAssessmentRuns(
      request: zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeReplicationTaskAssessmentRuns(request))
  def describeMetadataModelAssessments(
      request: zio.aws.databasemigration.model.DescribeMetadataModelAssessmentsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeMetadataModelAssessmentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeMetadataModelAssessments(request))
  def startDataMigration(
      request: zio.aws.databasemigration.model.StartDataMigrationRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.StartDataMigrationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startDataMigration(request))
  def reloadReplicationTables(
      request: zio.aws.databasemigration.model.ReloadReplicationTablesRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.ReloadReplicationTablesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.reloadReplicationTables(request))
  def describeEndpoints(
      request: zio.aws.databasemigration.model.DescribeEndpointsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeEndpointsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEndpoints(request))
  def startReplicationTaskAssessmentRun(
      request: zio.aws.databasemigration.model.StartReplicationTaskAssessmentRunRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.StartReplicationTaskAssessmentRunResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startReplicationTaskAssessmentRun(request))
  def describeSchemas(
      request: zio.aws.databasemigration.model.DescribeSchemasRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeSchemasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSchemas(request))
  def createEventSubscription(
      request: zio.aws.databasemigration.model.CreateEventSubscriptionRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.CreateEventSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEventSubscription(request))
  def describeConversionConfiguration(
      request: zio.aws.databasemigration.model.DescribeConversionConfigurationRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeConversionConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeConversionConfiguration(request))
  def describeEndpointSettings(
      request: zio.aws.databasemigration.model.DescribeEndpointSettingsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeEndpointSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEndpointSettings(request))
  def listTagsForResource(
      request: zio.aws.databasemigration.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def modifyEndpoint(
      request: zio.aws.databasemigration.model.ModifyEndpointRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.ModifyEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyEndpoint(request))
  def startRecommendations(
      request: zio.aws.databasemigration.model.StartRecommendationsRequest
  ): ZIO[zio.aws.databasemigration.DatabaseMigration, AwsError, Unit] =
    ZIO.serviceWithZIO(_.startRecommendations(request))
  def deleteFleetAdvisorCollector(
      request: zio.aws.databasemigration.model.DeleteFleetAdvisorCollectorRequest
  ): ZIO[zio.aws.databasemigration.DatabaseMigration, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteFleetAdvisorCollector(request))
  def deleteConnection(
      request: zio.aws.databasemigration.model.DeleteConnectionRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DeleteConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteConnection(request))
  def deleteFleetAdvisorDatabases(
      request: zio.aws.databasemigration.model.DeleteFleetAdvisorDatabasesRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DeleteFleetAdvisorDatabasesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteFleetAdvisorDatabases(request))
  def createEndpoint(
      request: zio.aws.databasemigration.model.CreateEndpointRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.CreateEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEndpoint(request))
  def createReplicationConfig(
      request: zio.aws.databasemigration.model.CreateReplicationConfigRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.CreateReplicationConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createReplicationConfig(request))
  def describeFleetAdvisorLsaAnalysis(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest
  ): ZStream[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.FleetAdvisorLsaAnalysisResponse.ReadOnly
  ] = ZStream.serviceWithStream(_.describeFleetAdvisorLsaAnalysis(request))
  def describeFleetAdvisorLsaAnalysisPaginated(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeFleetAdvisorLsaAnalysisResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFleetAdvisorLsaAnalysisPaginated(request))
  def describeEventSubscriptions(
      request: zio.aws.databasemigration.model.DescribeEventSubscriptionsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeEventSubscriptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEventSubscriptions(request))
  def deleteDataMigration(
      request: zio.aws.databasemigration.model.DeleteDataMigrationRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DeleteDataMigrationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDataMigration(request))
  def createDataMigration(
      request: zio.aws.databasemigration.model.CreateDataMigrationRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.CreateDataMigrationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDataMigration(request))
  def describeEndpointTypes(
      request: zio.aws.databasemigration.model.DescribeEndpointTypesRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeEndpointTypesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEndpointTypes(request))
  def describeConnections(
      request: zio.aws.databasemigration.model.DescribeConnectionsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeConnectionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeConnections(request))
  def runFleetAdvisorLsaAnalysis(): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.RunFleetAdvisorLsaAnalysisResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.runFleetAdvisorLsaAnalysis())
  def exportMetadataModelAssessment(
      request: zio.aws.databasemigration.model.ExportMetadataModelAssessmentRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.ExportMetadataModelAssessmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.exportMetadataModelAssessment(request))
  def describeMigrationProjects(
      request: zio.aws.databasemigration.model.DescribeMigrationProjectsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeMigrationProjectsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeMigrationProjects(request))
  def stopDataMigration(
      request: zio.aws.databasemigration.model.StopDataMigrationRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.StopDataMigrationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopDataMigration(request))
  def createInstanceProfile(
      request: zio.aws.databasemigration.model.CreateInstanceProfileRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.CreateInstanceProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createInstanceProfile(request))
  def describeMetadataModelImports(
      request: zio.aws.databasemigration.model.DescribeMetadataModelImportsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeMetadataModelImportsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeMetadataModelImports(request))
  def describeReplications(
      request: zio.aws.databasemigration.model.DescribeReplicationsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeReplicationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeReplications(request))
  def describeAccountAttributes(
      request: zio.aws.databasemigration.model.DescribeAccountAttributesRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeAccountAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAccountAttributes(request))
  def deleteReplicationConfig(
      request: zio.aws.databasemigration.model.DeleteReplicationConfigRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DeleteReplicationConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteReplicationConfig(request))
  def importCertificate(
      request: zio.aws.databasemigration.model.ImportCertificateRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.ImportCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importCertificate(request))
  def describeDataProviders(
      request: zio.aws.databasemigration.model.DescribeDataProvidersRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeDataProvidersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDataProviders(request))
  def batchStartRecommendations(
      request: zio.aws.databasemigration.model.BatchStartRecommendationsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.BatchStartRecommendationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchStartRecommendations(request))
  def reloadTables(
      request: zio.aws.databasemigration.model.ReloadTablesRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.ReloadTablesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.reloadTables(request))
  def rebootReplicationInstance(
      request: zio.aws.databasemigration.model.RebootReplicationInstanceRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.RebootReplicationInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rebootReplicationInstance(request))
  def deleteReplicationTask(
      request: zio.aws.databasemigration.model.DeleteReplicationTaskRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DeleteReplicationTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteReplicationTask(request))
  def describeEvents(
      request: zio.aws.databasemigration.model.DescribeEventsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeEventsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEvents(request))
  def startMetadataModelImport(
      request: zio.aws.databasemigration.model.StartMetadataModelImportRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.StartMetadataModelImportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startMetadataModelImport(request))
  def describeInstanceProfiles(
      request: zio.aws.databasemigration.model.DescribeInstanceProfilesRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeInstanceProfilesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeInstanceProfiles(request))
}
