package zio.aws.databasemigration.model
import scala.jdk.CollectionConverters.*
sealed trait VersionStatus {
  def unwrap
      : software.amazon.awssdk.services.databasemigration.model.VersionStatus
}
object VersionStatus {
  def wrap(
      value: software.amazon.awssdk.services.databasemigration.model.VersionStatus
  ): zio.aws.databasemigration.model.VersionStatus = value match {
    case software.amazon.awssdk.services.databasemigration.model.VersionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databasemigration.model.VersionStatus.UP_TO_DATE =>
      val r = UP_TO_DATE
      r
    case software.amazon.awssdk.services.databasemigration.model.VersionStatus.OUTDATED =>
      val r = OUTDATED
      r
    case software.amazon.awssdk.services.databasemigration.model.VersionStatus.UNSUPPORTED =>
      val r = UNSUPPORTED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.databasemigration.model.VersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.VersionStatus =
      software.amazon.awssdk.services.databasemigration.model.VersionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object UP_TO_DATE extends zio.aws.databasemigration.model.VersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.VersionStatus =
      software.amazon.awssdk.services.databasemigration.model.VersionStatus.UP_TO_DATE
  }
  case object OUTDATED extends zio.aws.databasemigration.model.VersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.VersionStatus =
      software.amazon.awssdk.services.databasemigration.model.VersionStatus.OUTDATED
  }
  case object UNSUPPORTED
      extends zio.aws.databasemigration.model.VersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.VersionStatus =
      software.amazon.awssdk.services.databasemigration.model.VersionStatus.UNSUPPORTED
  }
}
