package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StartRecommendationsRequestEntry(
    databaseId: String,
    settings: zio.aws.databasemigration.model.RecommendationSettings
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.StartRecommendationsRequestEntry = {
    import StartRecommendationsRequestEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.StartRecommendationsRequestEntry
      .builder()
      .databaseId(databaseId: java.lang.String)
      .settings(settings.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.StartRecommendationsRequestEntry.ReadOnly =
    zio.aws.databasemigration.model.StartRecommendationsRequestEntry
      .wrap(buildAwsValue())
}
object StartRecommendationsRequestEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.StartRecommendationsRequestEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.StartRecommendationsRequestEntry =
      zio.aws.databasemigration.model
        .StartRecommendationsRequestEntry(databaseId, settings.asEditable)
    def databaseId: String
    def settings
        : zio.aws.databasemigration.model.RecommendationSettings.ReadOnly
    def getDatabaseId: ZIO[Any, Nothing, String] = ZIO.succeed(databaseId)
    def getSettings: ZIO[
      Any,
      Nothing,
      zio.aws.databasemigration.model.RecommendationSettings.ReadOnly
    ] = ZIO.succeed(settings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.StartRecommendationsRequestEntry
  ) extends zio.aws.databasemigration.model.StartRecommendationsRequestEntry.ReadOnly {
    override val databaseId: String = impl.databaseId(): String
    override val settings
        : zio.aws.databasemigration.model.RecommendationSettings.ReadOnly =
      zio.aws.databasemigration.model.RecommendationSettings
        .wrap(impl.settings())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.StartRecommendationsRequestEntry
  ): zio.aws.databasemigration.model.StartRecommendationsRequestEntry.ReadOnly =
    new Wrapper(impl)
}
